/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.pattern;

import java.util.concurrent.atomic.AtomicInteger;
import net.uncontended.precipice.pattern.LoadBalancerStrategy;

public class RoundRobinStrategy
implements LoadBalancerStrategy {
    private static final int FLIP_POINT = 0x3FFFFFFF;
    private final int size;
    private final AtomicInteger counter;

    public RoundRobinStrategy(int size) {
        this(size, new AtomicInteger(0));
    }

    public RoundRobinStrategy(int size, AtomicInteger counter) {
        this.size = size;
        this.counter = counter;
    }

    @Override
    public int nextExecutorIndex() {
        int index = this.counter.getAndIncrement();
        if (index >= 0x3FFFFFFF) {
            this.resetCounter(index);
        }
        return index % this.size;
    }

    private void resetCounter(int start) {
        int index = start;
        while (index >= 0x3FFFFFFF && !this.counter.compareAndSet(index + 1, 0)) {
            index = this.counter.get();
        }
    }
}

