/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.pattern;

import java.util.Map;
import net.uncontended.precipice.CompletionService;
import net.uncontended.precipice.RejectedActionException;
import net.uncontended.precipice.RejectionReason;
import net.uncontended.precipice.ResilientCallback;
import net.uncontended.precipice.concurrent.DefaultResilientPromise;
import net.uncontended.precipice.concurrent.ResilientFuture;
import net.uncontended.precipice.concurrent.ResilientPromise;
import net.uncontended.precipice.pattern.CompletionPattern;
import net.uncontended.precipice.pattern.ResilientActionWithContext;
import net.uncontended.precipice.pattern.ResilientPatternAction;
import net.uncontended.precipice.pattern.ShotgunStrategy;
import net.uncontended.precipice.pattern.SubmissionPattern;

public class Shotgun<C>
implements SubmissionPattern<C>,
CompletionPattern<C> {
    private final CompletionService[] services;
    private final ShotgunStrategy strategy;
    private final C[] contexts;

    public Shotgun(Map<CompletionService, C> executorToContext, int submissionCount) {
        this(executorToContext, submissionCount, new ShotgunStrategy(executorToContext.size(), submissionCount));
    }

    public Shotgun(Map<CompletionService, C> executorToContext, int submissionCount, ShotgunStrategy strategy) {
        if (executorToContext.size() == 0) {
            throw new IllegalArgumentException("Cannot create Shotgun with 0 Executors.");
        }
        if (submissionCount > executorToContext.size()) {
            throw new IllegalArgumentException("Submission count cannot be greater than the number of services provided.");
        }
        this.services = new CompletionService[executorToContext.size()];
        this.contexts = new Object[executorToContext.size()];
        int i = 0;
        for (Map.Entry<CompletionService, C> entry : executorToContext.entrySet()) {
            this.services[i] = entry.getKey();
            this.contexts[i] = entry.getValue();
            ++i;
        }
        this.strategy = strategy;
    }

    @Override
    public <T> ResilientFuture<T> submit(ResilientPatternAction<T, C> action, long millisTimeout) {
        return this.submit(action, null, millisTimeout);
    }

    @Override
    public <T> ResilientFuture<T> submit(ResilientPatternAction<T, C> action, ResilientCallback<T> callback, long millisTimeout) {
        DefaultResilientPromise promise = new DefaultResilientPromise();
        this.submitAndComplete(action, promise, callback, millisTimeout);
        return new ResilientFuture(promise);
    }

    @Override
    public <T> void submitAndComplete(ResilientPatternAction<T, C> action, ResilientPromise<T> promise, long millisTimeout) {
        this.submitAndComplete(action, promise, null, millisTimeout);
    }

    @Override
    public <T> void submitAndComplete(ResilientPatternAction<T, C> action, ResilientPromise<T> promise, ResilientCallback<T> callback, long millisTimeout) {
        int[] servicesToTry = this.strategy.executorIndices();
        int submittedCount = 0;
        for (int serviceIndex : servicesToTry) {
            try {
                ResilientActionWithContext<T, C> actionWithContext = new ResilientActionWithContext<T, C>(action);
                actionWithContext.context = this.contexts[serviceIndex];
                CompletionService service = this.services[serviceIndex];
                service.submitAndComplete(actionWithContext, promise, callback, millisTimeout);
                ++submittedCount;
            }
            catch (RejectedActionException rejectedActionException) {
                // empty catch block
            }
            if (submittedCount == this.strategy.getSubmissionCount()) break;
        }
        if (submittedCount == 0) {
            throw new RejectedActionException(RejectionReason.ALL_SERVICES_REJECTED);
        }
    }

    @Override
    public void shutdown() {
        for (CompletionService service : this.services) {
            service.shutdown();
        }
    }
}

