/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.pattern;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class ShotgunStrategy {
    private final int submissionCount;
    private final int serviceCount;
    private final int[] serviceIndices;

    public ShotgunStrategy(int serviceCount, int submissionCount) {
        this.serviceCount = serviceCount;
        this.submissionCount = submissionCount;
        this.serviceIndices = new int[serviceCount];
        for (int i = 0; i < serviceCount; ++i) {
            this.serviceIndices[i] = i;
        }
    }

    public int[] executorIndices() {
        int[] orderToTry = new int[this.serviceCount];
        System.arraycopy(this.serviceIndices, 0, orderToTry, 0, this.serviceCount);
        this.shuffle(orderToTry);
        return orderToTry;
    }

    public int getSubmissionCount() {
        return this.submissionCount;
    }

    private void shuffle(int[] orderToTry) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = orderToTry.length - 1; i > 0; --i) {
            int index = ((Random)random).nextInt(i + 1);
            if (index == i) continue;
            int n = index;
            orderToTry[n] = orderToTry[n] ^ orderToTry[i];
            int n2 = i;
            orderToTry[n2] = orderToTry[n2] ^ orderToTry[index];
            int n3 = index;
            orderToTry[n3] = orderToTry[n3] ^ orderToTry[i];
        }
    }
}

