/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.timeout;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.uncontended.precipice.concurrent.ResilientTask;

public class TimeoutService {
    public static final TimeoutService defaultTimeoutService = new TimeoutService("default");
    private final DelayQueue<ResilientTask<?>> timeoutQueue = new DelayQueue();
    private final Thread timeoutThread;
    private AtomicBoolean isStarted = new AtomicBoolean(false);

    public TimeoutService(String name) {
        this.timeoutThread = this.createThread();
        this.timeoutThread.setName(name + "-timeout-thread");
    }

    public void scheduleTimeout(ResilientTask<?> task) {
        if (!this.isStarted.get()) {
            this.startThread();
        }
        this.timeoutQueue.offer(task);
    }

    private void startThread() {
        if (this.isStarted.compareAndSet(false, true)) {
            this.timeoutThread.start();
        }
    }

    private Thread createThread() {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        ResilientTask task = (ResilientTask)TimeoutService.this.timeoutQueue.take();
                        task.setTimedOut();
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        });
    }
}

