/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice;

import java.util.concurrent.Callable;
import net.uncontended.precipice.CompletionContext;
import net.uncontended.precipice.GuardRail;
import net.uncontended.precipice.Precipice;
import net.uncontended.precipice.factories.Synchronous;
import net.uncontended.precipice.result.TimeoutableResult;
import net.uncontended.precipice.timeout.PrecipiceTimeoutException;

public class CallService<Rejected extends Enum<Rejected>>
implements Precipice<TimeoutableResult, Rejected> {
    private final GuardRail<TimeoutableResult, Rejected> guardRail;

    public CallService(GuardRail<TimeoutableResult, Rejected> guardRail) {
        this.guardRail = guardRail;
    }

    @Override
    public GuardRail<TimeoutableResult, Rejected> guardRail() {
        return this.guardRail;
    }

    public <T> T call(Callable<T> callable) throws Exception {
        return this.call(callable, 1L);
    }

    public <T> T call(Callable<T> callable, long permitNumber) throws Exception {
        CompletionContext completable = Synchronous.acquirePermitsAndCompletable(this.guardRail, permitNumber);
        try {
            T result = callable.call();
            completable.complete(TimeoutableResult.SUCCESS, result);
            return result;
        }
        catch (PrecipiceTimeoutException e) {
            completable.completeExceptionally(TimeoutableResult.TIMEOUT, e);
            throw e;
        }
        catch (Exception e) {
            completable.completeExceptionally(TimeoutableResult.ERROR, e);
            throw e;
        }
    }
}

