/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice;

import net.uncontended.precipice.Completable;
import net.uncontended.precipice.ExecutionContext;
import net.uncontended.precipice.Failable;
import net.uncontended.precipice.PrecipiceFunction;
import net.uncontended.precipice.ResultView;

public class CompletionContext<Result extends Failable, V>
implements Completable<Result, V>,
ExecutionContext,
ResultView<Result, V> {
    private final long permits;
    private final long startTime;
    private final Completable<Result, V> wrappedCompletable;
    private PrecipiceFunction<Result, ExecutionContext> internalCallback;
    private boolean isCompleted = false;
    private Result result;
    private V value;
    private Throwable exception;

    public CompletionContext() {
        this(0L);
    }

    public CompletionContext(long permits) {
        this(permits, System.nanoTime());
    }

    public CompletionContext(long permits, long startTime) {
        this(permits, startTime, null);
    }

    public CompletionContext(long startTime, Completable<Result, V> wrappedCompletable) {
        this(1L, startTime, wrappedCompletable);
    }

    public CompletionContext(long permits, long startTime, Completable<Result, V> wrappedCompletable) {
        this.permits = permits;
        this.startTime = startTime;
        this.wrappedCompletable = wrappedCompletable;
    }

    @Override
    public long startNanos() {
        return this.startTime;
    }

    @Override
    public long permitCount() {
        return this.permits;
    }

    @Override
    public boolean complete(Result result, V value) {
        this.result = result;
        this.value = value;
        if (!this.isCompleted && this.internalCallback != null) {
            this.internalCallback.apply(result, this);
            if (this.wrappedCompletable != null) {
                this.wrappedCompletable.complete(result, value);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean completeExceptionally(Result result, Throwable exception) {
        this.result = result;
        this.exception = exception;
        if (!this.isCompleted && this.internalCallback != null) {
            this.internalCallback.apply(result, this);
            if (this.wrappedCompletable != null) {
                this.wrappedCompletable.completeExceptionally(result, exception);
            }
            return true;
        }
        return false;
    }

    @Override
    public ResultView<Result, V> resultView() {
        return this;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public Throwable getError() {
        return this.exception;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    public void internalOnComplete(PrecipiceFunction<Result, ExecutionContext> fn) {
        this.internalCallback = fn;
    }
}

