/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice;

import java.util.ArrayList;
import java.util.Map;
import net.uncontended.precipice.BackPressure;
import net.uncontended.precipice.ExecutionContext;
import net.uncontended.precipice.Failable;
import net.uncontended.precipice.GuardRailProperties;
import net.uncontended.precipice.PrecipiceFunction;
import net.uncontended.precipice.metrics.counts.WritableCounts;
import net.uncontended.precipice.metrics.latency.WritableLatency;
import net.uncontended.precipice.time.Clock;

public class GuardRail<Result extends Enum<Result>, Rejected extends Enum<Rejected>> {
    private final String name;
    private final Clock clock;
    private final PrecipiceFunction<Result, ExecutionContext> releaseFunction;
    private final WritableCounts<Result> resultCounts;
    private final WritableCounts<Rejected> rejectedCounts;
    private final WritableLatency<Result> resultLatency;
    private final ArrayList<BackPressure<Rejected>> backPressureList;
    private final Map<String, BackPressure<Rejected>> backPressureMap;

    private GuardRail(GuardRailProperties<Result, Rejected> properties) {
        this.name = properties.name;
        this.clock = properties.clock;
        this.resultCounts = properties.resultCounts;
        this.rejectedCounts = properties.rejectedCounts;
        this.resultLatency = properties.resultLatency;
        this.backPressureMap = properties.backPressureMap;
        this.backPressureList = new ArrayList<BackPressure<Rejected>>(this.backPressureMap.values());
        this.releaseFunction = new FinishingCallback();
    }

    public Rejected acquirePermits(long number) {
        return this.acquirePermits(number, this.clock.nanoTime());
    }

    public Rejected acquirePermits(long number, long nanoTime) {
        for (int i = 0; i < this.backPressureList.size(); ++i) {
            BackPressure<Rejected> bp = this.backPressureList.get(i);
            Rejected rejected = bp.acquirePermit(number, nanoTime);
            if (rejected == null) continue;
            this.rejectedCounts.write(rejected, number, nanoTime);
            for (int j = 0; j < i; ++j) {
                this.backPressureList.get(j).releasePermit(number, nanoTime);
            }
            return rejected;
        }
        return null;
    }

    public void releasePermitsWithoutResult(long number) {
        this.releasePermitsWithoutResult(number, this.clock.nanoTime());
    }

    public void releasePermitsWithoutResult(long number, long nanoTime) {
        for (BackPressure<Rejected> backPressure : this.backPressureList) {
            backPressure.releasePermit(number, nanoTime);
        }
    }

    public void releasePermits(ExecutionContext context, Result result) {
        this.releasePermits(context.permitCount(), result, context.startNanos(), this.clock.nanoTime());
    }

    public void releasePermits(ExecutionContext context, Result result, long nanoTime) {
        this.releasePermits(context.permitCount(), result, context.startNanos(), nanoTime);
    }

    public void releasePermits(long number, Result result, long startNanos) {
        this.releasePermits(number, result, startNanos, this.clock.nanoTime());
    }

    public void releasePermits(long number, Result result, long startNanos, long nanoTime) {
        this.resultCounts.write(result, number, nanoTime);
        this.resultLatency.write(result, number, nanoTime - startNanos, nanoTime);
        for (BackPressure<Rejected> backPressure : this.backPressureList) {
            backPressure.releasePermit(number, (Failable)result, nanoTime);
        }
    }

    public PrecipiceFunction<Result, ExecutionContext> releaseFunction() {
        return this.releaseFunction;
    }

    public String getName() {
        return this.name;
    }

    public WritableCounts<Result> getResultCounts() {
        return this.resultCounts;
    }

    public WritableCounts<Rejected> getRejectedCounts() {
        return this.rejectedCounts;
    }

    public WritableLatency<Result> getResultLatency() {
        return this.resultLatency;
    }

    public Map<String, BackPressure<Rejected>> getBackPressure() {
        return this.backPressureMap;
    }

    public Clock getClock() {
        return this.clock;
    }

    public static <Result extends Enum<Result>, Rejected extends Enum<Rejected>> GuardRail<Result, Rejected> create(GuardRailProperties<Result, Rejected> properties) {
        GuardRail<Result, Rejected> guardRail = new GuardRail<Result, Rejected>(properties);
        super.wireUp();
        return guardRail;
    }

    private void wireUp() {
        for (BackPressure<Rejected> bp : this.backPressureList) {
            bp.registerGuardRail(this);
        }
    }

    private class FinishingCallback
    implements PrecipiceFunction<Result, ExecutionContext> {
        private FinishingCallback() {
        }

        @Override
        public void apply(Result result, ExecutionContext context) {
            long endTime = GuardRail.this.clock.nanoTime();
            GuardRail.this.releasePermits(context, result, endTime);
        }
    }
}

