/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice;

import net.uncontended.precipice.BackPressure;
import net.uncontended.precipice.GuardRail;
import net.uncontended.precipice.GuardRailProperties;
import net.uncontended.precipice.metrics.counts.WritableCounts;
import net.uncontended.precipice.metrics.latency.NoOpLatency;
import net.uncontended.precipice.metrics.latency.WritableLatency;
import net.uncontended.precipice.time.Clock;

public class GuardRailBuilder<Result extends Enum<Result>, Rejected extends Enum<Rejected>> {
    private final GuardRailProperties<Result, Rejected> properties = new GuardRailProperties();

    public GuardRailBuilder<Result, Rejected> name(String name) {
        this.properties.name = name;
        return this;
    }

    public GuardRailBuilder<Result, Rejected> addBackPressure(BackPressure<Rejected> backPressure) {
        this.properties.backPressureMap.put(Integer.toString(this.properties.backPressureMap.size()), backPressure);
        return this;
    }

    public GuardRailBuilder<Result, Rejected> addBackPressure(String name, BackPressure<Rejected> backPressure) {
        this.properties.backPressureMap.put(name, backPressure);
        return this;
    }

    public GuardRailBuilder<Result, Rejected> resultCounts(WritableCounts<Result> resultCounts) {
        this.properties.resultCounts = resultCounts;
        return this;
    }

    public GuardRailBuilder<Result, Rejected> rejectedCounts(WritableCounts<Rejected> rejectedCounts) {
        this.properties.rejectedCounts = rejectedCounts;
        return this;
    }

    public GuardRailBuilder<Result, Rejected> resultLatency(WritableLatency<Result> resultLatency) {
        this.properties.resultLatency = resultLatency;
        return this;
    }

    public GuardRailBuilder<Result, Rejected> clock(Clock clock) {
        this.properties.clock = clock;
        return this;
    }

    public GuardRail<Result, Rejected> build() {
        if (this.properties.name == null) {
            throw new IllegalArgumentException("Name is required.");
        }
        if (this.properties.resultCounts == null) {
            throw new IllegalArgumentException("Result counts are required.");
        }
        if (this.properties.rejectedCounts == null) {
            throw new IllegalArgumentException("Rejected counts are required.");
        }
        if (this.properties.resultLatency == null) {
            this.properties.resultLatency = new NoOpLatency(this.properties.resultCounts.getMetricClazz());
        }
        return GuardRail.create(this.properties);
    }
}

