/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.circuit;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import net.uncontended.precipice.Failable;
import net.uncontended.precipice.circuit.HealthSnapshot;
import net.uncontended.precipice.metrics.IntervalIterator;
import net.uncontended.precipice.metrics.Rolling;
import net.uncontended.precipice.metrics.counts.PartitionedCount;

public class HealthGauge {
    private final CopyOnWriteArrayList<InternalGauge<?>> gauges = new CopyOnWriteArrayList();

    public synchronized HealthSnapshot getHealth(long timePeriod, TimeUnit timeUnit, long nanoTime) {
        long total = 0L;
        long failures = 0L;
        for (InternalGauge<?> gauge : this.gauges) {
            ((InternalGauge)gauge).refreshHealth(timePeriod, timeUnit, nanoTime);
            total += ((InternalGauge)gauge).total;
            failures += ((InternalGauge)gauge).failures;
        }
        return new HealthSnapshot(total, failures);
    }

    public <Result extends Enum<Result>> void add(Rolling<PartitionedCount<Result>> metrics) {
        this.gauges.add(new InternalGauge(metrics));
    }

    private static class InternalGauge<Result extends Enum<Result>> {
        private final Rolling<PartitionedCount<Result>> metrics;
        private final Class<Result> type;
        private long total = 0L;
        private long failures = 0L;

        private InternalGauge(Rolling<PartitionedCount<Result>> metrics) {
            this.metrics = metrics;
            this.type = metrics.current().getMetricClazz();
        }

        private void refreshHealth(long timePeriod, TimeUnit timeUnit, long nanoTime) {
            this.total = 0L;
            this.failures = 0L;
            IntervalIterator<PartitionedCount<Result>> counters = this.metrics.intervals(nanoTime);
            counters.limit(timePeriod, timeUnit);
            while (counters.hasNext()) {
                PartitionedCount<Result> metricCounter = counters.next();
                for (Enum result : (Enum[])this.type.getEnumConstants()) {
                    long metricCount = metricCounter.getCount(result);
                    this.total += metricCount;
                    if (!((Failable)((Object)result)).isFailure()) continue;
                    this.failures += metricCount;
                }
            }
        }
    }
}

