/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.circuit;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.uncontended.precipice.Failable;
import net.uncontended.precipice.GuardRail;
import net.uncontended.precipice.circuit.CircuitBreaker;
import net.uncontended.precipice.circuit.CircuitBreakerConfig;
import net.uncontended.precipice.circuit.HealthGauge;
import net.uncontended.precipice.circuit.HealthSnapshot;
import net.uncontended.precipice.metrics.Rolling;
import net.uncontended.precipice.metrics.counts.WritableCounts;

public class NoOpenCircuit<Rejected extends Enum<Rejected>>
implements CircuitBreaker<Rejected> {
    private static final int CLOSED = 0;
    private static final int OPEN = 1;
    private static final int FORCED_OPEN = 2;
    private final AtomicInteger state = new AtomicInteger(0);
    private final AtomicLong lastHealthNanoTime = new AtomicLong(0L);
    private final HealthGauge healthGauge;
    private final Runnable openRunnable;
    private volatile CircuitBreakerConfig<Rejected> breakerConfig;
    private volatile HealthSnapshot health = new HealthSnapshot(0L, 0L);

    public NoOpenCircuit(CircuitBreakerConfig<Rejected> breakerConfig, Runnable openRunnable) {
        this(breakerConfig, new HealthGauge(), openRunnable);
    }

    public NoOpenCircuit(CircuitBreakerConfig<Rejected> breakerConfig, HealthGauge healthGauge, Runnable openRunnable) {
        this.breakerConfig = breakerConfig;
        this.healthGauge = healthGauge;
        this.openRunnable = openRunnable;
    }

    @Override
    public boolean isOpen() {
        return this.state.get() != 0;
    }

    @Override
    public CircuitBreakerConfig<Rejected> getBreakerConfig() {
        return this.breakerConfig;
    }

    @Override
    public void setBreakerConfig(CircuitBreakerConfig<Rejected> breakerConfig) {
        this.breakerConfig = breakerConfig;
    }

    @Override
    public void forceOpen() {
        this.state.set(2);
    }

    @Override
    public void forceClosed() {
        this.state.set(0);
    }

    @Override
    public Rejected acquirePermit(long number, long nanoTime) {
        CircuitBreakerConfig<Rejected> config = this.breakerConfig;
        int state = this.state.get();
        if (state == 1) {
            return config.reason;
        }
        return state != 2 ? null : (Rejected)config.reason;
    }

    @Override
    public void releasePermit(long number, long nanoTime) {
    }

    @Override
    public void releasePermit(long number, Failable result, long nanoTime) {
        if (this.state.get() == 0) {
            CircuitBreakerConfig<Rejected> config = this.breakerConfig;
            HealthSnapshot health = this.getHealthSnapshot(config, nanoTime);
            long failures = health.failures;
            int failurePercentage = health.failurePercentage();
            if ((config.failureThreshold < failures || config.failurePercentageThreshold < failurePercentage && config.sampleSizeThreshold < health.total) && this.state.compareAndSet(0, 1)) {
                this.openRunnable.run();
            }
        }
    }

    @Override
    public <Result extends Enum<Result>> void registerGuardRail(GuardRail<Result, Rejected> guardRail) {
        WritableCounts<Result> metrics = guardRail.getResultCounts();
        if (!(metrics instanceof Rolling)) {
            throw new IllegalArgumentException("DefaultCircuitBreaker requires rolling result object");
        }
        this.healthGauge.add((Rolling)((Object)metrics));
    }

    private HealthSnapshot getHealthSnapshot(CircuitBreakerConfig<Rejected> config, long nanoTime) {
        long lastHealthNanoTime = this.lastHealthNanoTime.get();
        if (nanoTime - (lastHealthNanoTime + config.healthRefreshNanos) > 0L && this.lastHealthNanoTime.compareAndSet(lastHealthNanoTime, nanoTime)) {
            HealthSnapshot newHealth;
            this.health = newHealth = this.healthGauge.getHealth(config.trailingPeriodNanos, TimeUnit.NANOSECONDS, nanoTime);
            return newHealth;
        }
        return this.health;
    }
}

