/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.circuit.experimental;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.uncontended.precipice.Failable;
import net.uncontended.precipice.circuit.experimental.HealthChecker;
import net.uncontended.precipice.metrics.IntervalIterator;
import net.uncontended.precipice.metrics.Rolling;
import net.uncontended.precipice.metrics.counts.PartitionedCount;

public class DefaultHealthChecker
implements HealthChecker {
    private final long healthRefreshNanos;
    private final long trailingPeriodNanos;
    private final long failureThreshold;
    private final int failurePercentageThreshold;
    private final long sampleSizeThreshold;
    private final AtomicLong lastHealthNanoTime = new AtomicLong();
    private final ArrayList<InternalGauge<?>> gauges = new ArrayList();
    private volatile HealthSnapshot health = new HealthSnapshot(0L, 0L);

    public DefaultHealthChecker(long healthRefreshNanos, long trailingPeriodNanos, long failureThreshold, int failurePercentageThreshold, long sampleSizeThreshold) {
        this.healthRefreshNanos = healthRefreshNanos;
        this.trailingPeriodNanos = trailingPeriodNanos;
        this.failureThreshold = failureThreshold;
        this.failurePercentageThreshold = failurePercentageThreshold;
        this.sampleSizeThreshold = sampleSizeThreshold;
    }

    @Override
    public boolean isHealthy(long nanoTime) {
        HealthSnapshot health = this.getHealthSnapshot(nanoTime);
        long failures = health.failures;
        int failurePercentage = health.failurePercentage;
        return this.failureThreshold >= failures && (this.failurePercentageThreshold >= failurePercentage || this.sampleSizeThreshold >= health.total);
    }

    public void init(long nanoTime) {
        this.lastHealthNanoTime.set(nanoTime);
    }

    private HealthSnapshot getHealthSnapshot(long currentNanoTime) {
        long lastHealthNanoTime = this.lastHealthNanoTime.get();
        if (currentNanoTime - (lastHealthNanoTime + this.healthRefreshNanos) > 0L && this.lastHealthNanoTime.compareAndSet(lastHealthNanoTime, currentNanoTime)) {
            HealthSnapshot newHealth;
            this.health = newHealth = this.getHealth(this.trailingPeriodNanos, currentNanoTime);
            return newHealth;
        }
        return this.health;
    }

    private synchronized HealthSnapshot getHealth(long trailingPeriodNanos, long nanoTime) {
        long total = 0L;
        long failures = 0L;
        for (InternalGauge<?> gauge : this.gauges) {
            ((InternalGauge)gauge).refreshHealth(trailingPeriodNanos, nanoTime);
            total += ((InternalGauge)gauge).total;
            failures += ((InternalGauge)gauge).failures;
        }
        return new HealthSnapshot(total, failures);
    }

    private static class InternalGauge<Result extends Enum<Result>> {
        private final Rolling<PartitionedCount<Result>> metrics;
        private final Class<Result> type;
        private long total = 0L;
        private long failures = 0L;

        private InternalGauge(Rolling<PartitionedCount<Result>> metrics) {
            this.metrics = metrics;
            this.type = metrics.current().getMetricClazz();
        }

        private void refreshHealth(long trailingPeriodNanos, long nanoTime) {
            this.total = 0L;
            this.failures = 0L;
            IntervalIterator<PartitionedCount<Result>> counters = this.metrics.intervals(nanoTime);
            counters.limit(trailingPeriodNanos, TimeUnit.NANOSECONDS);
            while (counters.hasNext()) {
                PartitionedCount<Result> metricCounter = counters.next();
                for (Enum result : (Enum[])this.type.getEnumConstants()) {
                    long metricCount = metricCounter.getCount(result);
                    this.total += metricCount;
                    if (!((Failable)((Object)result)).isFailure()) continue;
                    this.failures += metricCount;
                }
            }
        }
    }

    private static class HealthSnapshot {
        private final long total;
        private final long failures;
        private final int failurePercentage;

        private HealthSnapshot(long total, long failures) {
            this.total = total;
            this.failures = failures;
            this.failurePercentage = total != 0L ? (int)(100L * failures / total) : 0;
        }
    }
}

