/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.circuit.experimental;

import net.uncontended.precipice.Failable;
import net.uncontended.precipice.GuardRail;
import net.uncontended.precipice.circuit.CircuitBreaker;
import net.uncontended.precipice.circuit.CircuitBreakerConfig;
import net.uncontended.precipice.circuit.experimental.AbstractBreaker;
import net.uncontended.precipice.circuit.experimental.HealthChecker;

public class RefactoredBreaker<Rejected extends Enum<Rejected>>
extends AbstractBreaker
implements CircuitBreaker<Rejected> {
    private final Rejected reason;
    private final Rejected forcedReason;
    private final long backOffTimeNanos;
    private final HealthChecker checker;
    private volatile long lastTestedNanoTime;

    public RefactoredBreaker(Rejected reason, Rejected forcedReason, HealthChecker checker, long backOffTimeNanos) {
        this.reason = reason;
        this.forcedReason = forcedReason;
        this.checker = checker;
        this.backOffTimeNanos = backOffTimeNanos;
    }

    @Override
    public CircuitBreakerConfig<Rejected> getBreakerConfig() {
        return null;
    }

    @Override
    public void setBreakerConfig(CircuitBreakerConfig<Rejected> breakerConfig) {
    }

    @Override
    public Rejected acquirePermit(long number, long nanoTime) {
        int state = this.state.get();
        if (state == 1) {
            if (nanoTime - (this.backOffTimeNanos + this.lastTestedNanoTime) < 0L) {
                return this.reason;
            }
            this.lastTestedNanoTime = nanoTime;
        }
        return state != 2 ? null : (Rejected)this.forcedReason;
    }

    @Override
    public void releasePermit(long number, long nanoTime) {
    }

    @Override
    public void releasePermit(long number, Failable result, long nanoTime) {
        if (result.isSuccess()) {
            if (this.state.get() == 1) {
                this.state.compareAndSet(1, 0);
            }
        } else if (this.state.get() == 0 && !this.checker.isHealthy(nanoTime)) {
            this.lastTestedNanoTime = nanoTime;
            this.state.compareAndSet(0, 1);
        }
    }

    @Override
    public <Result extends Enum<Result>> void registerGuardRail(GuardRail<Result, Rejected> guardRail) {
    }
}

