/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import net.uncontended.precipice.Cancellable;
import net.uncontended.precipice.Completable;
import net.uncontended.precipice.ExecutionContext;
import net.uncontended.precipice.Failable;
import net.uncontended.precipice.PrecipiceFunction;
import net.uncontended.precipice.ResultView;
import net.uncontended.precipice.concurrent.PrecipiceFuture;
import net.uncontended.precipice.concurrent.PrecipicePromise;

public class Eventual<Result extends Failable, V>
implements PrecipiceFuture<Result, V>,
PrecipicePromise<Result, V>,
ExecutionContext {
    private final long permitCount;
    private final long startNanos;
    private final Completable<Result, V> wrappedPromise;
    private volatile V value;
    private volatile Throwable throwable;
    private volatile Cancellable cancellable;
    private volatile boolean isCancelled = false;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicReference<Result> result = new AtomicReference<Object>(null);
    private final AtomicReference<PrecipiceFunction<Result, V>> successCallback = new AtomicReference();
    private final AtomicReference<PrecipiceFunction<Result, Throwable>> errorCallback = new AtomicReference();
    private PrecipiceFunction<Result, ExecutionContext> internalCallback;

    public Eventual() {
        this(0L);
    }

    public Eventual(long permitCount) {
        this(permitCount, System.nanoTime());
    }

    public Eventual(long permitCount, long startNanos) {
        this(permitCount, startNanos, null);
    }

    public Eventual(Completable<Result, V> completable) {
        this(0L, System.nanoTime(), completable);
    }

    public Eventual(long permitCount, long startNanos, Completable<Result, V> completable) {
        this.permitCount = permitCount;
        this.startNanos = startNanos;
        this.wrappedPromise = completable;
    }

    @Override
    public boolean complete(Result result, V value) {
        if (this.result.get() == null && this.result.compareAndSet(null, result)) {
            this.value = value;
            this.executeInternalCallback(result);
            this.latch.countDown();
            PrecipiceFunction<Result, V> cb = this.successCallback.get();
            if (cb != null && this.successCallback.compareAndSet(cb, null)) {
                cb.apply(result, value);
            }
            if (this.wrappedPromise != null) {
                this.wrappedPromise.complete(result, value);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean completeExceptionally(Result result, Throwable exception) {
        if (this.result.get() == null && this.result.compareAndSet(null, result)) {
            this.throwable = exception;
            this.executeInternalCallback(result);
            this.latch.countDown();
            PrecipiceFunction<Result, Throwable> cb = this.errorCallback.get();
            if (cb != null && this.errorCallback.compareAndSet(cb, null)) {
                cb.apply(result, exception);
            }
            if (this.wrappedPromise != null) {
                this.wrappedPromise.completeExceptionally(result, exception);
            }
            return true;
        }
        return false;
    }

    @Override
    public ResultView<Result, V> resultView() {
        return this;
    }

    @Override
    public PrecipiceFuture<Result, V> future() {
        return this;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.latch.await();
        if (this.value != null) {
            return this.value;
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        throw new ExecutionException(this.throwable);
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.latch.await(timeout, unit)) {
            if (this.value != null) {
                return this.value;
            }
            if (this.isCancelled()) {
                throw new CancellationException();
            }
            throw new ExecutionException(this.throwable);
        }
        throw new TimeoutException();
    }

    @Override
    public boolean isDone() {
        return this.result.get() != null;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (mayInterruptIfRunning && this.cancellable != null && !this.isDone()) {
            this.isCancelled = true;
            this.cancellable.cancel();
            return true;
        }
        return false;
    }

    @Override
    public void await() throws InterruptedException {
        this.latch.await();
    }

    @Override
    public void await(long duration, TimeUnit unit) throws InterruptedException {
        this.latch.await(duration, unit);
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public Throwable getError() {
        return this.throwable;
    }

    @Override
    public void onSuccess(PrecipiceFunction<Result, V> fn) {
        Failable localResult2;
        Failable localResult = (Failable)this.result.get();
        if (localResult != null && !localResult.isFailure()) {
            fn.apply(localResult, this.value);
        } else if (this.successCallback.compareAndSet(null, fn) && (localResult2 = (Failable)this.result.get()) != null && !localResult2.isFailure() && this.successCallback.compareAndSet(fn, null)) {
            fn.apply(localResult2, this.value);
        }
    }

    @Override
    public void onError(PrecipiceFunction<Result, Throwable> fn) {
        Failable localResult2;
        Failable localResult = (Failable)this.result.get();
        if (localResult != null && localResult.isFailure()) {
            fn.apply(localResult, this.throwable);
        } else if (this.errorCallback.compareAndSet(null, fn) && (localResult2 = (Failable)this.result.get()) != null && localResult2.isFailure() && this.errorCallback.compareAndSet(fn, null)) {
            fn.apply(localResult2, this.throwable);
        }
    }

    @Override
    public Result getResult() {
        return (Result)((Failable)this.result.get());
    }

    @Override
    public long startNanos() {
        return this.startNanos;
    }

    @Override
    public long permitCount() {
        return this.permitCount;
    }

    public void setCancellable(Cancellable cancellable) {
        this.cancellable = cancellable;
    }

    public void internalOnComplete(PrecipiceFunction<Result, ExecutionContext> fn) {
        this.internalCallback = fn;
    }

    private void executeInternalCallback(Result result) {
        if (this.internalCallback != null) {
            this.internalCallback.apply(result, this);
        }
    }
}

