/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.factories;

import net.uncontended.precipice.Completable;
import net.uncontended.precipice.GuardRail;
import net.uncontended.precipice.concurrent.Eventual;
import net.uncontended.precipice.rejected.RejectedException;

public final class Asynchronous {
    private Asynchronous() {
    }

    public static <Result extends Enum<Result>, Rejected extends Enum<Rejected>, R> Eventual<Result, R> acquireSinglePermitAndPromise(GuardRail<Result, Rejected> guardRail) {
        return Asynchronous.acquirePermitsAndPromise(guardRail, 1L, null);
    }

    public static <Result extends Enum<Result>, Rejected extends Enum<Rejected>, R> Eventual<Result, R> acquireSinglePermitAndPromise(GuardRail<Result, Rejected> guardRail, Completable<Result, R> externalCompletable) {
        return Asynchronous.acquirePermitsAndPromise(guardRail, 1L, externalCompletable);
    }

    public static <Result extends Enum<Result>, Rejected extends Enum<Rejected>, R> Eventual<Result, R> acquirePermitsAndPromise(GuardRail<Result, Rejected> guardRail, long number) {
        return Asynchronous.acquirePermitsAndPromise(guardRail, number, null);
    }

    public static <Result extends Enum<Result>, Rejected extends Enum<Rejected>, R> Eventual<Result, R> acquirePermitsAndPromise(GuardRail<Result, Rejected> guardRail, long number, Completable<Result, R> externalCompletable) {
        long startTime = guardRail.getClock().nanoTime();
        Rejected rejected = guardRail.acquirePermits(number, startTime);
        if (rejected != null) {
            throw new RejectedException((Enum)rejected);
        }
        return Asynchronous.getPromise(guardRail, number, startTime, externalCompletable);
    }

    public static <Result extends Enum<Result>, Rejected extends Enum<Rejected>, R> Eventual<Result, R> getPromise(GuardRail<Result, Rejected> guardRail, long permitNumber, long nanoTime) {
        return Asynchronous.getPromise(guardRail, permitNumber, nanoTime, null);
    }

    public static <Result extends Enum<Result>, Rejected extends Enum<Rejected>, R> Eventual<Result, R> getPromise(GuardRail<Result, Rejected> guardRail, long permitNumber, long nanoTime, Completable<Result, R> externalCompletable) {
        Eventual<Result, R> promise = new Eventual<Result, R>(permitNumber, nanoTime, externalCompletable);
        promise.internalOnComplete(guardRail.releaseFunction());
        return promise;
    }
}

