/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.factories;

import net.uncontended.precipice.Completable;
import net.uncontended.precipice.CompletionContext;
import net.uncontended.precipice.GuardRail;
import net.uncontended.precipice.rejected.RejectedException;

public final class Synchronous {
    private Synchronous() {
    }

    public static <Result extends Enum<Result>, Rejected extends Enum<Rejected>, R> CompletionContext<Result, R> acquireSinglePermitAndCompletable(GuardRail<Result, Rejected> guardRail) {
        return Synchronous.acquirePermitsAndCompletable(guardRail, 1L, null);
    }

    public static <Result extends Enum<Result>, Rejected extends Enum<Rejected>, R> CompletionContext<Result, R> acquireSinglePermitAndCompletable(GuardRail<Result, Rejected> guardRail, Completable<Result, R> externalCompletable) {
        return Synchronous.acquirePermitsAndCompletable(guardRail, 1L, externalCompletable);
    }

    public static <Result extends Enum<Result>, Rejected extends Enum<Rejected>, R> CompletionContext<Result, R> acquirePermitsAndCompletable(GuardRail<Result, Rejected> guardRail, long number) {
        return Synchronous.acquirePermitsAndCompletable(guardRail, number, null);
    }

    public static <Result extends Enum<Result>, Rejected extends Enum<Rejected>, R> CompletionContext<Result, R> acquirePermitsAndCompletable(GuardRail<Result, Rejected> guardRail, long number, Completable<Result, R> externalCompletable) {
        long startTime = guardRail.getClock().nanoTime();
        Rejected rejected = guardRail.acquirePermits(number, startTime);
        if (rejected != null) {
            throw new RejectedException((Enum)rejected);
        }
        return Synchronous.getCompletable(guardRail, number, startTime, externalCompletable);
    }

    public static <Result extends Enum<Result>, Rejected extends Enum<Rejected>, R> CompletionContext<Result, R> getCompletable(GuardRail<Result, Rejected> guardRail, long permitNumber, long nanoTime) {
        return Synchronous.getCompletable(guardRail, permitNumber, nanoTime, null);
    }

    public static <Result extends Enum<Result>, Rejected extends Enum<Rejected>, R> CompletionContext<Result, R> getCompletable(GuardRail<Result, Rejected> guardRail, long permitNumber, long nanoTime, Completable<Result, R> externalCompletable) {
        CompletionContext<Result, R> completable = new CompletionContext<Result, R>(permitNumber, nanoTime, externalCompletable);
        completable.internalOnComplete(guardRail.releaseFunction());
        return completable;
    }
}

