/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.metrics.counts;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import net.uncontended.precipice.metrics.IntervalIterator;
import net.uncontended.precipice.metrics.counts.PartitionedCount;

public final class Accumulator {
    public static <T extends Enum<T>> long count(Iterator<PartitionedCount<T>> intervals, T type) {
        long count = 0L;
        while (intervals.hasNext()) {
            PartitionedCount<T> metricCounter = intervals.next();
            count += metricCounter.getCount(type);
        }
        return count;
    }

    public static <T extends Enum<T>> long countForPeriod(IntervalIterator<PartitionedCount<T>> intervals, T type, long duration, TimeUnit unit) {
        intervals.limit(duration, unit);
        return Accumulator.count(intervals, type);
    }

    public static <T extends Enum<T>> Counts<T> counts(Iterator<PartitionedCount<T>> intervals) {
        Counts counts = new Counts();
        Class metricClazz = null;
        while (intervals.hasNext()) {
            PartitionedCount<Enum> metricCounter = intervals.next();
            long[] countArray = counts.array();
            if (countArray == null) {
                metricClazz = metricCounter.getMetricClazz();
                counts.init(metricClazz);
                countArray = counts.array();
            }
            for (Enum type : (Enum[])metricClazz.getEnumConstants()) {
                int n = type.ordinal();
                countArray[n] = countArray[n] + metricCounter.getCount(type);
            }
        }
        return counts;
    }

    public static <T extends Enum<T>> Counts<T> countsForPeriod(IntervalIterator<PartitionedCount<T>> intervals, long duration, TimeUnit unit) {
        intervals.limit(duration, unit);
        return Accumulator.counts(intervals);
    }

    public static class Counts<T extends Enum<T>> {
        private long[] counts = null;

        public long get(T type) {
            if (this.counts != null) {
                return this.counts[((Enum)type).ordinal()];
            }
            return 0L;
        }

        void init(Class<T> clazz) {
            this.counts = new long[((Enum[])clazz.getEnumConstants()).length];
        }

        long[] array() {
            return this.counts;
        }
    }
}

