/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.metrics.counts;

import java.util.concurrent.atomic.AtomicLongArray;
import net.uncontended.precipice.metrics.AbstractMetrics;
import net.uncontended.precipice.metrics.counts.PartitionedCount;

public class AtomicLongCounter<T extends Enum<T>>
extends AbstractMetrics<T>
implements PartitionedCount<T> {
    private final AtomicLongArray metrics;

    public AtomicLongCounter(Class<T> clazz) {
        super(clazz);
        Enum[] metricValues = (Enum[])clazz.getEnumConstants();
        this.metrics = new AtomicLongArray(metricValues.length);
    }

    @Override
    public void add(T metric, long delta) {
        this.metrics.getAndAdd(((Enum)metric).ordinal(), delta);
    }

    @Override
    public long getCount(T metric) {
        return this.metrics.get(((Enum)metric).ordinal());
    }

    @Override
    public long total() {
        long total = 0L;
        int length = this.metrics.length();
        for (int i = 0; i < length; ++i) {
            total += this.metrics.get(i);
        }
        return total;
    }

    @Override
    public void reset() {
        int length = this.metrics.length();
        for (int i = 0; i < length; ++i) {
            this.metrics.set(i, 0L);
        }
    }
}

