/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.metrics.counts;

import net.uncontended.precipice.metrics.counts.AtomicLongCounter;
import net.uncontended.precipice.metrics.counts.LongAdderCounter;
import net.uncontended.precipice.metrics.counts.LongCounter;
import net.uncontended.precipice.metrics.counts.PartitionedCount;
import net.uncontended.precipice.metrics.tools.Allocator;

public final class Counters {
    private Counters() {
    }

    public static <T extends Enum<T>> Allocator<PartitionedCount<T>> longAdder(Class<T> clazz) {
        return new LongAdderAllocator(clazz);
    }

    public static <T extends Enum<T>> Allocator<PartitionedCount<T>> atomicLong(Class<T> clazz) {
        return new AtomicLongAllocator(clazz);
    }

    public static <T extends Enum<T>> Allocator<PartitionedCount<T>> longCounter(Class<T> clazz) {
        return new LongAllocator(clazz);
    }

    private static class LongAllocator<T extends Enum<T>>
    implements Allocator<PartitionedCount<T>> {
        private final Class<T> clazz;

        private LongAllocator(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public PartitionedCount<T> allocateNew() {
            return new LongCounter<T>(this.clazz);
        }
    }

    private static class AtomicLongAllocator<T extends Enum<T>>
    implements Allocator<PartitionedCount<T>> {
        private final Class<T> clazz;

        private AtomicLongAllocator(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public PartitionedCount<T> allocateNew() {
            return new AtomicLongCounter<T>(this.clazz);
        }
    }

    private static class LongAdderAllocator<T extends Enum<T>>
    implements Allocator<PartitionedCount<T>> {
        private final Class<T> clazz;

        private LongAdderAllocator(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public PartitionedCount<T> allocateNew() {
            return new LongAdderCounter<T>(this.clazz);
        }
    }
}

