/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.metrics.counts;

import net.uncontended.precipice.concurrent.util.LongAdder;
import net.uncontended.precipice.metrics.AbstractMetrics;
import net.uncontended.precipice.metrics.counts.PartitionedCount;

public class LongAdderCounter<T extends Enum<T>>
extends AbstractMetrics<T>
implements PartitionedCount<T> {
    private final LongAdder[] metrics;

    public LongAdderCounter(Class<T> clazz) {
        super(clazz);
        Enum[] metricValues = (Enum[])clazz.getEnumConstants();
        this.metrics = new LongAdder[metricValues.length];
        for (Enum metric : metricValues) {
            this.metrics[metric.ordinal()] = new LongAdder();
        }
    }

    @Override
    public void add(T metric, long delta) {
        this.metrics[((Enum)metric).ordinal()].add(delta);
    }

    @Override
    public long getCount(T metric) {
        return this.metrics[((Enum)metric).ordinal()].longValue();
    }

    @Override
    public long total() {
        long total = 0L;
        for (LongAdder adder : this.metrics) {
            total += adder.longValue();
        }
        return total;
    }

    @Override
    public void reset() {
        for (LongAdder adder : this.metrics) {
            adder.reset();
        }
    }
}

