/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.metrics.counts;

import net.uncontended.precipice.metrics.AbstractMetrics;
import net.uncontended.precipice.metrics.counts.PartitionedCount;

public class LongCounter<T extends Enum<T>>
extends AbstractMetrics<T>
implements PartitionedCount<T> {
    private final long[] metrics;

    public LongCounter(Class<T> clazz) {
        super(clazz);
        Enum[] metricValues = (Enum[])clazz.getEnumConstants();
        this.metrics = new long[metricValues.length];
    }

    @Override
    public void add(T metric, long delta) {
        int n = ((Enum)metric).ordinal();
        this.metrics[n] = this.metrics[n] + delta;
    }

    @Override
    public long getCount(T metric) {
        return this.metrics[((Enum)metric).ordinal()];
    }

    @Override
    public long total() {
        long total = 0L;
        for (long metric : this.metrics) {
            total += metric;
        }
        return total;
    }

    @Override
    public void reset() {
        int length = this.metrics.length;
        for (int i = 0; i < length; ++i) {
            this.metrics[i] = 0L;
        }
    }
}

