/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.metrics.counts;

import net.uncontended.precipice.metrics.AbstractMetrics;
import net.uncontended.precipice.metrics.IntervalIterator;
import net.uncontended.precipice.metrics.Rolling;
import net.uncontended.precipice.metrics.counts.Counters;
import net.uncontended.precipice.metrics.counts.NoOpCounter;
import net.uncontended.precipice.metrics.counts.PartitionedCount;
import net.uncontended.precipice.metrics.counts.RollingCountsBuilder;
import net.uncontended.precipice.metrics.counts.WritableCounts;
import net.uncontended.precipice.metrics.tools.CircularBuffer;
import net.uncontended.precipice.metrics.tools.RollingMetrics;
import net.uncontended.precipice.time.SystemTime;

public class RollingCounts<T extends Enum<T>>
extends AbstractMetrics<T>
implements WritableCounts<T>,
Rolling<PartitionedCount<T>> {
    private final NoOpCounter<T> noOpCounter;
    private final RollingMetrics<PartitionedCount<T>> rolling;

    public RollingCounts(Class<T> clazz, int buckets, long nanosPerBucket) {
        this(new RollingMetrics<PartitionedCount<T>>(Counters.longAdder(clazz), new CircularBuffer(buckets, nanosPerBucket, System.nanoTime()), SystemTime.getInstance()));
    }

    public RollingCounts(RollingMetrics<PartitionedCount<T>> rolling) {
        super(rolling.current().getMetricClazz());
        this.rolling = rolling;
        this.noOpCounter = new NoOpCounter(this.getMetricClazz());
    }

    @Override
    public void write(T metric, long number, long nanoTime) {
        this.current(nanoTime).add(metric, number);
    }

    @Override
    public PartitionedCount<T> current() {
        return this.rolling.current();
    }

    @Override
    public PartitionedCount<T> current(long nanoTime) {
        return this.rolling.current(nanoTime);
    }

    @Override
    public IntervalIterator<PartitionedCount<T>> intervals() {
        return this.rolling.intervalsWithDefault(this.noOpCounter);
    }

    @Override
    public IntervalIterator<PartitionedCount<T>> intervals(long nanoTime) {
        return this.rolling.intervalsWithDefault(nanoTime, this.noOpCounter);
    }

    public static <V extends Enum<V>> RollingCountsBuilder<V> builder(Class<V> clazz) {
        return new RollingCountsBuilder<V>(clazz);
    }
}

