/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.metrics.counts;

import net.uncontended.precipice.metrics.AbstractMetrics;
import net.uncontended.precipice.metrics.counts.LongAdderCounter;
import net.uncontended.precipice.metrics.counts.PartitionedCount;
import net.uncontended.precipice.metrics.counts.WritableCounts;

public class TotalCounts<T extends Enum<T>>
extends AbstractMetrics<T>
implements WritableCounts<T>,
PartitionedCount<T> {
    private final PartitionedCount<T> counter;

    public TotalCounts(Class<T> clazz) {
        super(clazz);
        this.counter = new LongAdderCounter<T>(clazz);
    }

    public TotalCounts(PartitionedCount<T> counter) {
        super(counter.getMetricClazz());
        this.counter = counter;
    }

    @Override
    public void write(T result, long number, long nanoTime) {
        this.counter.add(result, number);
    }

    @Override
    public long getCount(T metric) {
        return this.counter.getCount(metric);
    }

    @Override
    public long total() {
        return this.counter.total();
    }

    @Override
    public void add(T metric, long delta) {
        this.counter.add(metric, delta);
    }

    @Override
    public void reset() {
        this.counter.reset();
    }
}

