/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.metrics.latency;

import net.uncontended.precipice.metrics.AbstractMetrics;
import net.uncontended.precipice.metrics.latency.PartitionedLatency;
import org.HdrHistogram.Histogram;

public class BaseHDRHistogram<T extends Enum<T>>
extends AbstractMetrics<T>
implements PartitionedLatency<T> {
    protected final Histogram[] histograms;

    public BaseHDRHistogram(Class<T> clazz, Histogram[] histograms) {
        super(clazz);
        this.histograms = histograms;
    }

    @Override
    public void record(T metric, long number, long nanoLatency) {
        Histogram histogram = this.histograms[((Enum)metric).ordinal()];
        long highestTrackableValue = histogram.getHighestTrackableValue();
        long potentiallyTruncated = highestTrackableValue > nanoLatency ? nanoLatency : highestTrackableValue;
        histogram.recordValueWithCount(potentiallyTruncated, number);
    }

    @Override
    public Histogram getHistogram(T metric) {
        return this.histograms[((Enum)metric).ordinal()];
    }

    @Override
    public long getValueAtPercentile(T metric, double percentile) {
        return this.histograms[((Enum)metric).ordinal()].getValueAtPercentile(percentile);
    }

    @Override
    public boolean isHDR() {
        return true;
    }

    @Override
    public void reset() {
        for (Histogram histogram : this.histograms) {
            histogram.reset();
        }
    }
}

