/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.metrics.latency;

import java.util.concurrent.TimeUnit;
import net.uncontended.precipice.metrics.latency.AtomicHistogram;
import net.uncontended.precipice.metrics.latency.ConcurrentHistogram;
import net.uncontended.precipice.metrics.latency.PartitionedLatency;
import net.uncontended.precipice.metrics.tools.Allocator;

public final class Latency {
    private Latency() {
    }

    public static <T extends Enum<T>> Allocator<PartitionedLatency<T>> concurrentHDRHistogram(Class<T> clazz) {
        return Latency.concurrentHDRHistogram(clazz, TimeUnit.HOURS.toNanos(1L), 2);
    }

    private static <T extends Enum<T>> Allocator<PartitionedLatency<T>> concurrentHDRHistogram(Class<T> clazz, long highestTrackableValue, int numberOfSignificantValueDigits) {
        return new ConcurrentHDRHistogramFactory<T>(clazz, highestTrackableValue, numberOfSignificantValueDigits);
    }

    public static <T extends Enum<T>> Allocator<PartitionedLatency<T>> atomicHDRHistogram(Class<T> clazz) {
        return Latency.atomicHDRHistogram(clazz, TimeUnit.HOURS.toNanos(1L), 2);
    }

    public static <T extends Enum<T>> Allocator<PartitionedLatency<T>> atomicHDRHistogram(Class<T> clazz, long highestTrackableValue, int numberOfSignificantValueDigits) {
        return new AtomicHDRHistogramFactory<T>(clazz, highestTrackableValue, numberOfSignificantValueDigits);
    }

    private static class AtomicHDRHistogramFactory<T extends Enum<T>>
    implements Allocator<PartitionedLatency<T>> {
        private final Class<T> clazz;
        private final long highestTrackableValue;
        private final int numberOfSignificantValueDigits;

        public AtomicHDRHistogramFactory(Class<T> clazz, long highestTrackableValue, int numberOfSignificantValueDigits) {
            this.clazz = clazz;
            this.highestTrackableValue = highestTrackableValue;
            this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
        }

        @Override
        public PartitionedLatency<T> allocateNew() {
            return new AtomicHistogram<T>(this.clazz, this.highestTrackableValue, this.numberOfSignificantValueDigits);
        }
    }

    private static class ConcurrentHDRHistogramFactory<T extends Enum<T>>
    implements Allocator<PartitionedLatency<T>> {
        private final Class<T> clazz;
        private final long highestTrackableValue;
        private final int numberOfSignificantValueDigits;

        public ConcurrentHDRHistogramFactory(Class<T> clazz, long highestTrackableValue, int numberOfSignificantValueDigits) {
            this.clazz = clazz;
            this.highestTrackableValue = highestTrackableValue;
            this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
        }

        @Override
        public PartitionedLatency<T> allocateNew() {
            return new ConcurrentHistogram<T>(this.clazz, this.highestTrackableValue, this.numberOfSignificantValueDigits);
        }
    }
}

