/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.metrics.latency;

import net.uncontended.precipice.metrics.AbstractMetrics;
import net.uncontended.precipice.metrics.latency.LatencyRecorderBuilder;
import net.uncontended.precipice.metrics.latency.PartitionedLatency;
import net.uncontended.precipice.metrics.latency.WritableLatency;
import net.uncontended.precipice.metrics.tools.MetricRecorder;
import net.uncontended.precipice.metrics.tools.Recorder;

public class LatencyRecorder<T extends Enum<T>>
extends AbstractMetrics<T>
implements WritableLatency<T>,
Recorder<PartitionedLatency<T>> {
    private final MetricRecorder<PartitionedLatency<T>> metricRecorder;

    public LatencyRecorder(MetricRecorder<PartitionedLatency<T>> metricRecorder) {
        super(((PartitionedLatency)metricRecorder.activeInterval()).getMetricClazz());
        this.metricRecorder = metricRecorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(T metric, long number, long nanoLatency, long nanoTime) {
        long permit = this.metricRecorder.startRecord();
        try {
            ((PartitionedLatency)this.metricRecorder.activeInterval()).record(metric, number, nanoLatency);
        }
        finally {
            this.metricRecorder.endRecord(permit);
        }
    }

    @Override
    public PartitionedLatency<T> activeInterval() {
        return (PartitionedLatency)this.metricRecorder.activeInterval();
    }

    @Override
    public long activeIntervalStart() {
        return this.metricRecorder.activeIntervalStart();
    }

    @Override
    public PartitionedLatency<T> captureInterval() {
        return (PartitionedLatency)this.metricRecorder.captureInterval();
    }

    @Override
    public PartitionedLatency<T> captureInterval(long nanotime) {
        return (PartitionedLatency)this.metricRecorder.captureInterval(nanotime);
    }

    @Override
    public PartitionedLatency<T> captureInterval(PartitionedLatency<T> newInterval) {
        return this.metricRecorder.captureInterval(newInterval);
    }

    @Override
    public synchronized PartitionedLatency<T> captureInterval(PartitionedLatency<T> newInterval, long nanoTime) {
        return this.metricRecorder.captureInterval(newInterval, nanoTime);
    }

    public static <T extends Enum<T>> LatencyRecorderBuilder<T> builder(Class<T> clazz) {
        return new LatencyRecorderBuilder<T>(clazz);
    }
}

