/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.metrics.latency;

import net.uncontended.precipice.metrics.Resettable;
import net.uncontended.precipice.metrics.latency.Latency;
import net.uncontended.precipice.metrics.latency.LatencyRecorder;
import net.uncontended.precipice.metrics.latency.PartitionedLatency;
import net.uncontended.precipice.metrics.tools.MetricRecorder;
import net.uncontended.precipice.metrics.tools.RecorderBuilder;
import net.uncontended.precipice.metrics.tools.RelaxedFlipControl;

public class LatencyRecorderBuilder<T extends Enum<T>>
extends RecorderBuilder<PartitionedLatency<T>, LatencyRecorder<T>> {
    private final Class<T> clazz;

    public LatencyRecorderBuilder(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public LatencyRecorder<T> build() {
        if (this.allocator == null) {
            this.allocator = Latency.concurrentHDRHistogram(this.clazz);
        }
        if (this.active == null) {
            this.active = this.allocator.allocateNew();
        }
        if (this.inactive == null) {
            this.inactive = this.allocator.allocateNew();
        }
        if (this.flipControl == null) {
            this.flipControl = new RelaxedFlipControl();
        }
        return new LatencyRecorder(new MetricRecorder<Resettable>((Resettable)this.active, (Resettable)this.inactive, this.flipControl, this.clock));
    }
}

