/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.metrics.latency;

import net.uncontended.precipice.metrics.AbstractMetrics;
import net.uncontended.precipice.metrics.IntervalIterator;
import net.uncontended.precipice.metrics.Rolling;
import net.uncontended.precipice.metrics.latency.Latency;
import net.uncontended.precipice.metrics.latency.NoOpLatency;
import net.uncontended.precipice.metrics.latency.PartitionedLatency;
import net.uncontended.precipice.metrics.latency.WritableLatency;
import net.uncontended.precipice.metrics.tools.Allocator;
import net.uncontended.precipice.metrics.tools.CircularBuffer;
import net.uncontended.precipice.metrics.tools.RollingMetrics;
import net.uncontended.precipice.time.SystemTime;

public class RollingLatency<T extends Enum<T>>
extends AbstractMetrics<T>
implements WritableLatency<T>,
Rolling<PartitionedLatency<T>> {
    private final RollingMetrics<PartitionedLatency<T>> rolling;
    private final NoOpLatency<T> noOpLatency;

    public RollingLatency(Class<T> clazz, int buckets, long nanosPerBucket) {
        this(Latency.atomicHDRHistogram(clazz), buckets, nanosPerBucket);
    }

    public RollingLatency(Allocator<PartitionedLatency<T>> allocator, int buckets, long nanosPerBucket) {
        this(new RollingMetrics<PartitionedLatency<T>>(allocator, new CircularBuffer(buckets, nanosPerBucket, System.nanoTime()), SystemTime.getInstance()));
    }

    public RollingLatency(RollingMetrics<PartitionedLatency<T>> rolling) {
        super(rolling.current().getMetricClazz());
        this.rolling = rolling;
        this.noOpLatency = new NoOpLatency(this.getMetricClazz());
    }

    @Override
    public void write(T metric, long number, long nanoLatency, long nanoTime) {
        this.rolling.current(nanoTime).record(metric, number, nanoLatency);
    }

    @Override
    public PartitionedLatency<T> current() {
        return this.rolling.current();
    }

    @Override
    public PartitionedLatency<T> current(long nanoTime) {
        return this.rolling.current(nanoTime);
    }

    @Override
    public IntervalIterator<PartitionedLatency<T>> intervals() {
        return this.rolling.intervalsWithDefault(this.noOpLatency);
    }

    @Override
    public IntervalIterator<PartitionedLatency<T>> intervals(long nanoTime) {
        return this.rolling.intervalsWithDefault(nanoTime, this.noOpLatency);
    }
}

