/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.metrics.latency;

import net.uncontended.precipice.metrics.AbstractMetrics;
import net.uncontended.precipice.metrics.latency.ConcurrentHistogram;
import net.uncontended.precipice.metrics.latency.PartitionedLatency;
import net.uncontended.precipice.metrics.latency.WritableLatency;
import org.HdrHistogram.Histogram;

public class TotalLatency<T extends Enum<T>>
extends AbstractMetrics<T>
implements WritableLatency<T>,
PartitionedLatency<T> {
    private final PartitionedLatency<T> latency;

    public TotalLatency(PartitionedLatency<T> latency) {
        super(latency.getMetricClazz());
        this.latency = latency;
    }

    public TotalLatency(Class<T> clazz) {
        super(clazz);
        this.latency = new ConcurrentHistogram<T>(clazz);
    }

    @Override
    public void record(T result, long number, long nanoLatency) {
        this.latency.record(result, number, nanoLatency);
    }

    @Override
    public Histogram getHistogram(T metric) {
        return this.latency.getHistogram(metric);
    }

    @Override
    public long getValueAtPercentile(T metric, double percentile) {
        return this.latency.getValueAtPercentile(metric, percentile);
    }

    @Override
    public boolean isHDR() {
        return this.latency.isHDR();
    }

    @Override
    public void reset() {
        this.latency.reset();
    }

    @Override
    public void write(T metric, long number, long nanoLatency, long nanoTime) {
        this.record(metric, number, nanoLatency);
    }
}

