/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.metrics.tools;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.uncontended.precipice.metrics.IntervalIterator;
import net.uncontended.precipice.metrics.tools.Allocator;
import net.uncontended.precipice.metrics.tools.FlipControl;
import net.uncontended.precipice.metrics.tools.Recorder;
import net.uncontended.precipice.time.Clock;
import net.uncontended.precipice.time.SystemTime;

public class BufferedRecorder<T>
implements Recorder<T> {
    private final int bufferSize;
    private final AtomicReferenceArray<Interval<T>> buffer;
    private final FlipControl<T> flipControl;
    private final Clock clock;
    private final int mask;
    private volatile long currentIndex;
    private Interval<T> inactive;

    public BufferedRecorder(FlipControl<T> flipControl, int bufferSize) {
        this(flipControl, bufferSize, SystemTime.getInstance());
    }

    public BufferedRecorder(FlipControl<T> flipControl, int bufferSize, Clock clock) {
        this.flipControl = flipControl;
        this.clock = clock;
        this.bufferSize = bufferSize;
        bufferSize = BufferedRecorder.nextPositivePowerOfTwo(bufferSize);
        this.mask = bufferSize - 1;
        this.buffer = new AtomicReferenceArray(bufferSize);
        this.inactive = new Interval(null, -1L, -1L);
    }

    public void init(Allocator<T> allocator) {
        int length = this.buffer.length();
        long nanoTime = this.clock.nanoTime();
        for (int i = 0; i < length; ++i) {
            int difference = length - i;
            long endTime = nanoTime - (long)difference;
            this.buffer.set(i, new Interval(allocator.allocateNew(), endTime - 1L, endTime));
        }
        Interval<T> interval = this.buffer.get(0);
        ((Interval)interval).startNanos = nanoTime;
        ((Interval)interval).isInit = true;
        this.flipControl.flip(((Interval)interval).object);
    }

    public IntervalIterator<T> intervals() {
        return this.intervals(this.clock.nanoTime());
    }

    public IntervalIterator<T> intervals(long nanoTime) {
        BufferedIterator bufferedIterator = new BufferedIterator();
        bufferedIterator.reset(nanoTime);
        return bufferedIterator;
    }

    private static int nextPositivePowerOfTwo(int bufferSize) {
        return 1 << 32 - Integer.numberOfLeadingZeros(bufferSize - 1);
    }

    @Override
    public T activeInterval() {
        return this.flipControl.active();
    }

    @Override
    public long activeIntervalStart() {
        return 0L;
    }

    @Override
    public T captureInterval() {
        return null;
    }

    @Override
    public T captureInterval(long nanotime) {
        return null;
    }

    @Override
    public T captureInterval(T newInterval) {
        return null;
    }

    @Override
    public T captureInterval(T newInterval, long nanoTime) {
        return null;
    }

    public T advance(T newValue, long nanoTime) {
        long oldIndex = this.currentIndex;
        long newIndex = oldIndex + 1L;
        int newRelativeIndex = (int)newIndex & this.mask;
        Interval<T> reuse = this.buffer.get(newRelativeIndex);
        ((Interval)this.inactive).startNanos = nanoTime;
        ((Interval)this.inactive).startNanos = nanoTime - 1L;
        ((Interval)this.inactive).object = newValue;
        this.buffer.set(newRelativeIndex, this.inactive);
        ((Interval)this.inactive).isInit = true;
        this.flipControl.flip(((Interval)this.inactive).object);
        Interval<T> closingInterval = this.buffer.get((int)oldIndex & this.mask);
        ((Interval)closingInterval).endNanos = nanoTime;
        this.currentIndex = newIndex;
        Object returned = ((Interval)reuse).object;
        ((Interval)reuse).object = null;
        this.inactive = reuse;
        return (T)returned;
    }

    private class BufferedIterator
    implements IntervalIterator<T> {
        private long index;
        private long maxIndex;
        private Interval<T> value;
        private T dead = null;
        private long nanoTime;

        private BufferedIterator() {
        }

        @Override
        public boolean hasNext() {
            long diff = this.maxIndex - this.index;
            return diff >= 0L;
        }

        @Override
        public T next() {
            long absolute = this.index++;
            this.value = (Interval)BufferedRecorder.this.buffer.get((int)absolute & BufferedRecorder.this.mask);
            if (this.nanoTime - this.value.startNanos < 0L) {
                return this.dead;
            }
            return this.value.object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public long intervalStart() {
            return this.value.startNanos - this.nanoTime;
        }

        @Override
        public long intervalEnd() {
            if (this.value.endNanos - this.value.startNanos >= 0L) {
                return this.value.endNanos - this.nanoTime;
            }
            return 0L;
        }

        @Override
        public IntervalIterator<T> limit(long duration, TimeUnit unit) {
            long limitTime = this.nanoTime - unit.toNanos(duration);
            long newIndex = this.index;
            while (this.maxIndex - this.index >= 0L) {
                long absolute;
                ++newIndex;
                if (((Interval)BufferedRecorder.this.buffer.get((int)absolute & BufferedRecorder.this.mask)).startNanos - limitTime > 0L) continue;
                break;
            }
            this.index = newIndex;
            return this;
        }

        @Override
        public IntervalIterator<T> reset(long nanoTime) {
            this.nanoTime = nanoTime;
            this.maxIndex = BufferedRecorder.this.currentIndex;
            this.index = this.maxIndex - (long)(BufferedRecorder.this.bufferSize - 1);
            while (this.maxIndex - this.index >= 0L && !((Interval)BufferedRecorder.this.buffer.get((int)this.index & BufferedRecorder.this.mask)).isInit) {
                ++this.index;
            }
            return this;
        }
    }

    private static class Interval<T> {
        private T object;
        private long startNanos;
        private long endNanos;
        private boolean isInit = false;

        private Interval(T object, long startNanos, long endNanos) {
            this.object = object;
            this.startNanos = startNanos;
            this.endNanos = endNanos;
        }

        public String toString() {
            return "Interval{object=" + this.object + ", startNanos=" + this.startNanos + ", endNanos=" + this.endNanos + ", isInit=" + this.isInit + '}';
        }
    }
}

