/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.metrics.tools;

import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.uncontended.precipice.metrics.IntervalIterator;

public class CircularBuffer<T> {
    private final AtomicReferenceArray<Slot<T>> buffer;
    private final int mask;
    private final int totalSlots;
    private final long nanosPerSlot;
    private final long startNanos;

    public CircularBuffer(int slotsToTrack, long nanosPerSlot) {
        this(slotsToTrack, nanosPerSlot, System.nanoTime());
    }

    public CircularBuffer(int slotsToTrack, long nanosPerSlot, long startNanos) {
        CircularBuffer.validateSlotSize(nanosPerSlot);
        this.nanosPerSlot = nanosPerSlot;
        this.startNanos = startNanos;
        this.totalSlots = slotsToTrack;
        int arraySlot = CircularBuffer.nextPositivePowerOfTwo(slotsToTrack);
        this.mask = arraySlot - 1;
        this.buffer = new AtomicReferenceArray(arraySlot);
        for (int i = 0; i < arraySlot; ++i) {
            this.buffer.set(i, new Slot(null, startNanos, startNanos));
        }
    }

    public T getSlot(long nanoTime) {
        long absoluteSlot = this.currentAbsoluteSlot(nanoTime);
        int relativeSlot = this.toRelative(absoluteSlot);
        Slot<T> slot = this.buffer.get(relativeSlot);
        if (((Slot)slot).endNanos - nanoTime > 0L && nanoTime - ((Slot)slot).startNanos >= 0L) {
            return (T)((Slot)slot).object;
        }
        return null;
    }

    public T putOrGet(long nanoTime, T object) {
        Slot<T> slot;
        long absoluteSlot = this.currentAbsoluteSlot(nanoTime);
        int relativeSlot = this.toRelative(absoluteSlot);
        while (nanoTime - ((Slot)(slot = this.buffer.get(relativeSlot))).startNanos >= 0L) {
            if (((Slot)slot).endNanos - nanoTime > 0L) {
                return (T)((Slot)slot).object;
            }
            long startNanos = this.startNanos + absoluteSlot * this.nanosPerSlot;
            long endNanos = startNanos + this.nanosPerSlot;
            Slot newSlot = new Slot(object, startNanos, endNanos);
            if (!this.buffer.compareAndSet(relativeSlot, slot, newSlot)) continue;
            return (T)newSlot.object;
        }
        return object;
    }

    public IntervalIterator<T> intervals(long nanoTime, T dead) {
        Intervals intervals = new Intervals(dead);
        intervals.reset(nanoTime);
        return intervals;
    }

    private int toRelative(long absoluteSlot) {
        return (int)(absoluteSlot & (long)this.mask);
    }

    private long currentAbsoluteSlot(long nanoTime) {
        return (nanoTime - this.startNanos) / this.nanosPerSlot;
    }

    private static void validateSlotSize(long nanosPerSlot) {
        if (nanosPerSlot < 0L) {
            String message = "Nanos per slot must be positive. Found: [%s duration]";
            throw new IllegalArgumentException(String.format(message, Integer.MAX_VALUE));
        }
    }

    private static int nextPositivePowerOfTwo(int slotsToTrack) {
        return 1 << 32 - Integer.numberOfLeadingZeros(slotsToTrack - 1);
    }

    private class Intervals
    implements IntervalIterator<T> {
        private final T dead;
        private long nanoTime;
        private long currentInterval;
        private long remainderNanos;

        private Intervals(T dead) {
            this.dead = dead;
        }

        @Override
        public boolean hasNext() {
            long diff = this.nanoTime - this.currentInterval;
            return diff >= 0L;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long currentInterval = this.currentInterval;
            this.currentInterval += CircularBuffer.this.nanosPerSlot;
            Object object = CircularBuffer.this.getSlot(currentInterval);
            if (object != null) {
                return object;
            }
            return this.dead;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public long intervalStart() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return -(this.nanoTime - this.currentInterval + this.remainderNanos);
        }

        @Override
        public long intervalEnd() {
            long diff = this.nanoTime - this.currentInterval;
            if (diff < 0L) {
                throw new NoSuchElementException();
            }
            if (diff == 0L) {
                return 0L;
            }
            return -(this.nanoTime - this.currentInterval - CircularBuffer.this.nanosPerSlot + this.remainderNanos);
        }

        public long lastIntervalStart() {
            return -(this.nanoTime - this.currentInterval + this.remainderNanos);
        }

        public long lastIntervalEnd() {
            return -(this.nanoTime - this.currentInterval - CircularBuffer.this.nanosPerSlot + this.remainderNanos);
        }

        @Override
        public IntervalIterator<T> limit(long duration, TimeUnit unit) {
            long nanosLimit = unit.toNanos(duration);
            long limitedInterval = this.nanoTime - nanosLimit + CircularBuffer.this.nanosPerSlot;
            if (this.currentInterval - limitedInterval < 0L) {
                this.currentInterval = CircularBuffer.this.currentAbsoluteSlot(limitedInterval) * CircularBuffer.this.nanosPerSlot + CircularBuffer.this.startNanos + this.remainderNanos;
            }
            return this;
        }

        @Override
        public IntervalIterator<T> reset(long nanoTime) {
            this.nanoTime = nanoTime;
            this.remainderNanos = (nanoTime - CircularBuffer.this.startNanos) % CircularBuffer.this.nanosPerSlot;
            this.currentInterval = nanoTime - (long)(CircularBuffer.this.totalSlots - 1) * CircularBuffer.this.nanosPerSlot;
            return this;
        }
    }

    private static class Slot<T> {
        private final T object;
        private final long startNanos;
        private final long endNanos;

        private Slot(T object, long startNanos, long endNanos) {
            this.object = object;
            this.startNanos = startNanos;
            this.endNanos = endNanos;
        }

        public String toString() {
            return "Slot{object=" + this.object + ", startNanos=" + this.startNanos + ", endNanos=" + this.endNanos + '}';
        }
    }
}

