/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.metrics.tools;

import net.uncontended.precipice.metrics.Resettable;
import net.uncontended.precipice.metrics.tools.FlipControl;
import net.uncontended.precipice.metrics.tools.Recorder;
import net.uncontended.precipice.time.Clock;

public class MetricRecorder<T extends Resettable>
implements Recorder<T> {
    private final FlipControl<T> flipControl;
    private final Clock clock;
    private T inactive;
    private volatile long intervalStart;

    public MetricRecorder(T active, T inactive, FlipControl<T> flipControl, Clock clock) {
        this.flipControl = flipControl;
        this.clock = clock;
        this.flipControl.flip(active);
        this.inactive = inactive;
        this.intervalStart = clock.nanoTime();
    }

    @Override
    public T activeInterval() {
        return (T)((Resettable)this.flipControl.active());
    }

    @Override
    public long activeIntervalStart() {
        return this.intervalStart;
    }

    @Override
    public T captureInterval() {
        return (T)this.captureInterval(this.clock.nanoTime());
    }

    @Override
    public T captureInterval(long nanotime) {
        this.inactive.reset();
        return this.captureInterval(this.inactive, nanotime);
    }

    @Override
    public T captureInterval(T newInterval) {
        return this.captureInterval(newInterval, this.clock.nanoTime());
    }

    @Override
    public synchronized T captureInterval(T newInterval, long nanoTime) {
        Resettable newlyInactive = (Resettable)this.flipControl.flip(newInterval);
        this.inactive = newlyInactive;
        this.intervalStart = nanoTime;
        return (T)newlyInactive;
    }

    public long startRecord() {
        return this.flipControl.startRecord();
    }

    public void endRecord(long permit) {
        this.flipControl.endRecord(permit);
    }
}

