/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.metrics.tools;

import net.uncontended.precipice.metrics.tools.Allocator;
import net.uncontended.precipice.metrics.tools.FlipControl;
import net.uncontended.precipice.time.Clock;
import net.uncontended.precipice.time.SystemTime;

public abstract class RecorderBuilder<T, S> {
    protected FlipControl<T> flipControl;
    protected T active;
    protected T inactive;
    protected Allocator<T> allocator;
    protected Clock clock = SystemTime.getInstance();

    public RecorderBuilder<T, S> initialActive(T active) {
        this.active = active;
        return this;
    }

    public RecorderBuilder<T, S> initialInactive(T inactive) {
        this.inactive = inactive;
        return this;
    }

    public RecorderBuilder<T, S> withAllocator(Allocator<T> allocator) {
        this.allocator = allocator;
        return this;
    }

    public RecorderBuilder<T, S> withRecorder(FlipControl<T> flipControl) {
        this.flipControl = flipControl;
        return this;
    }

    public RecorderBuilder<T, S> withClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public abstract S build();
}

