/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.metrics.tools;

import java.util.concurrent.TimeUnit;
import net.uncontended.precipice.metrics.tools.Allocator;
import net.uncontended.precipice.metrics.tools.CircularBuffer;
import net.uncontended.precipice.metrics.tools.RollingMetrics;
import net.uncontended.precipice.time.Clock;
import net.uncontended.precipice.time.SystemTime;

public abstract class RollingBuilder<T, S> {
    protected Clock clock = SystemTime.getInstance();
    protected int buckets = -1;
    protected long nanosPerBucket = -1L;
    protected Allocator<T> allocator;

    public RollingBuilder<T, S> bucketCount(int buckets) {
        this.buckets = buckets;
        return this;
    }

    public RollingBuilder<T, S> bucketResolution(long duration, TimeUnit unit) {
        this.nanosPerBucket = unit.toNanos(duration);
        return this;
    }

    public RollingBuilder<T, S> withClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public RollingBuilder<T, S> withAllocator(Allocator<T> allocator) {
        this.allocator = allocator;
        return this;
    }

    public abstract S build();

    protected RollingMetrics<T> buildRollingMetrics() {
        if (this.allocator == null) {
            throw new IllegalArgumentException("Allocator cannot be null.");
        }
        if (this.buckets < 0) {
            throw new IllegalArgumentException("Number of buckets tracked must be positive. Found: " + this.buckets);
        }
        if (this.nanosPerBucket <= 0L) {
            throw new IllegalArgumentException("Nano seconds per bucket must be greater than 0. Found: " + this.nanosPerBucket);
        }
        CircularBuffer circularBuffer = new CircularBuffer(this.buckets, this.nanosPerBucket, this.clock.nanoTime());
        return new RollingMetrics<T>(this.allocator, circularBuffer, this.clock);
    }
}

