/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.metrics.tools;

import net.uncontended.precipice.metrics.IntervalIterator;
import net.uncontended.precipice.metrics.Rolling;
import net.uncontended.precipice.metrics.tools.Allocator;
import net.uncontended.precipice.metrics.tools.CircularBuffer;
import net.uncontended.precipice.time.Clock;

public class RollingMetrics<T>
implements Rolling<T> {
    private final Allocator<T> allocator;
    private final Clock clock;
    private final CircularBuffer<T> buffer;

    public RollingMetrics(Allocator<T> allocator, CircularBuffer<T> buffer, Clock clock) {
        this.allocator = allocator;
        this.buffer = buffer;
        this.clock = clock;
    }

    @Override
    public T current() {
        return this.current(this.clock.nanoTime());
    }

    @Override
    public T current(long nanoTime) {
        T current = this.buffer.getSlot(nanoTime);
        if (current == null) {
            current = this.buffer.putOrGet(nanoTime, this.allocator.allocateNew());
        }
        return current;
    }

    @Override
    public IntervalIterator<T> intervals() {
        return this.intervals(this.clock.nanoTime());
    }

    @Override
    public IntervalIterator<T> intervals(long nanoTime) {
        return this.buffer.intervals(nanoTime, null);
    }

    public IntervalIterator<T> intervalsWithDefault(T default0) {
        return this.buffer.intervals(this.clock.nanoTime(), default0);
    }

    public IntervalIterator<T> intervalsWithDefault(long nanoTime, T default0) {
        return this.buffer.intervals(nanoTime, default0);
    }
}

