/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.pattern;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.uncontended.precipice.GuardRail;
import net.uncontended.precipice.Precipice;
import net.uncontended.precipice.pattern.AllocatingSequenceFactory;
import net.uncontended.precipice.pattern.PatternStrategy;
import net.uncontended.precipice.pattern.Sequence;
import net.uncontended.precipice.pattern.SequenceFactory;
import net.uncontended.precipice.pattern.WritableSequence;

public class Pattern<Result extends Enum<Result>, C extends Precipice<Result, ?>> {
    private final List<C> pool;
    private final PatternStrategy strategy;
    private final SequenceFactory<C> sequenceFactory;

    public Pattern(Collection<C> precipices, PatternStrategy strategy) {
        this(precipices, strategy, new AllocatingSequenceFactory());
    }

    public Pattern(Collection<C> precipices, PatternStrategy strategy, SequenceFactory<C> sequenceFactory) {
        if (precipices.isEmpty()) {
            throw new IllegalArgumentException("Cannot create Pattern with 0 Precipices.");
        }
        if (strategy.acquireCount() > precipices.size()) {
            throw new IllegalArgumentException("Attempt count cannot be greater than the number of precipices.");
        }
        ArrayList<C> pool = new ArrayList<C>(precipices.size());
        pool.addAll(precipices);
        this.pool = pool;
        this.strategy = strategy;
        this.sequenceFactory = sequenceFactory;
    }

    public Sequence<C> getPrecipices(long permits) {
        return this.getPrecipices(permits, System.nanoTime());
    }

    public Sequence<C> getPrecipices(long permits, long nanoTime) {
        WritableSequence<C> precipices = this.getPrecipiceSequence();
        this.setupSequence(permits, nanoTime, precipices);
        return precipices;
    }

    public List<C> getAllPrecipices() {
        return this.pool;
    }

    private void setupSequence(long permits, long nanoTime, WritableSequence<C> precipices) {
        int acquiredCount = 0;
        for (Integer index : this.strategy.nextIndices()) {
            Precipice precipice = (Precipice)this.pool.get(index);
            GuardRail guardRail = precipice.guardRail();
            Object rejected = guardRail.acquirePermits(permits, nanoTime);
            if (rejected == null) {
                precipices.add(precipice);
                ++acquiredCount;
            }
            if (acquiredCount != this.strategy.acquireCount()) continue;
            break;
        }
    }

    private WritableSequence<C> getPrecipiceSequence() {
        return this.sequenceFactory.getSequence(this.strategy.acquireCount());
    }
}

