/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.pattern;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import net.uncontended.precipice.pattern.PatternStrategy;
import net.uncontended.precipice.pattern.SingleReaderArrayIterable;

public class RoundRobinLoadBalancer
implements PatternStrategy {
    private final long flipPoint;
    private final int size;
    private final int maxAcquireAttempts;
    private final AtomicLong counter;

    public RoundRobinLoadBalancer(int size) {
        this(size, size);
    }

    public RoundRobinLoadBalancer(int size, int maxAcquireAttempts) {
        this(size, maxAcquireAttempts, new AtomicLong(0L));
    }

    public RoundRobinLoadBalancer(int size, int maxAcquireAttempts, AtomicLong counter) {
        this.size = size;
        this.maxAcquireAttempts = maxAcquireAttempts;
        this.counter = counter;
        this.flipPoint = Long.MAX_VALUE - (long)maxAcquireAttempts;
    }

    @Override
    public Iterable<Integer> nextIndices() {
        long index = this.counter.getAndIncrement();
        if (index >= this.flipPoint) {
            this.resetCounter(index);
        }
        SingleReaderArrayIterable iterable = new SingleReaderArrayIterable(this.maxAcquireAttempts);
        Integer[] orderToTry = iterable.getIndices();
        for (int i = 0; i < this.maxAcquireAttempts; ++i) {
            orderToTry[i] = (int)((index + (long)i) % (long)this.size);
        }
        RoundRobinLoadBalancer.shuffleTail(orderToTry);
        return iterable;
    }

    @Override
    public int acquireCount() {
        return 1;
    }

    private static void shuffleTail(Integer[] orderToTry) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = orderToTry.length - 1; i > 1; --i) {
            int index = ((Random)random).nextInt(i) + 1;
            if (index == i) continue;
            Integer[] integerArray = orderToTry;
            int n = index;
            Integer.valueOf(integerArray[n] ^ orderToTry[i]);
            integerArray = orderToTry;
            n = i;
            Integer.valueOf(integerArray[n] ^ orderToTry[index]);
            integerArray = orderToTry;
            n = index;
            Integer.valueOf(integerArray[n] ^ orderToTry[i]);
        }
    }

    private void resetCounter(long start) {
        long index = start;
        while (index >= this.flipPoint && !this.counter.compareAndSet(index + 1L, 0L)) {
            index = this.counter.get();
        }
    }
}

