/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.pattern;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.uncontended.precipice.pattern.PatternStrategy;
import net.uncontended.precipice.pattern.SingleReaderArrayIterable;

public class Shotgun
implements PatternStrategy {
    private final int acquireCount;
    private final int serviceCount;
    private final Integer[] serviceIndices;

    public Shotgun(int serviceCount, int acquireCount) {
        this.serviceCount = serviceCount;
        this.acquireCount = acquireCount;
        this.serviceIndices = new Integer[serviceCount];
        for (int i = 0; i < serviceCount; ++i) {
            this.serviceIndices[i] = i;
        }
    }

    @Override
    public Iterable<Integer> nextIndices() {
        SingleReaderArrayIterable iterable = new SingleReaderArrayIterable(this.serviceCount);
        Integer[] orderToTry = iterable.getIndices();
        System.arraycopy(this.serviceIndices, 0, orderToTry, 0, this.serviceCount);
        Shotgun.shuffle(orderToTry);
        return iterable;
    }

    @Override
    public int acquireCount() {
        return this.acquireCount;
    }

    private static void shuffle(Integer[] orderToTry) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = orderToTry.length - 1; i > 0; --i) {
            int index = ((Random)random).nextInt(i + 1);
            if (index == i) continue;
            Integer[] integerArray = orderToTry;
            int n = index;
            Integer.valueOf(integerArray[n] ^ orderToTry[i]);
            integerArray = orderToTry;
            n = i;
            Integer.valueOf(integerArray[n] ^ orderToTry[index]);
            integerArray = orderToTry;
            n = index;
            Integer.valueOf(integerArray[n] ^ orderToTry[i]);
        }
    }
}

