/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.pattern;

import java.util.Iterator;
import net.uncontended.precipice.pattern.Sequence;

public class WritableSequence<E>
implements Sequence<E>,
Iterator<E> {
    private final Object[] children;
    private int index = 0;
    private int count = 0;

    public WritableSequence(int size) {
        this.children = new Object[size];
    }

    @Override
    public boolean hasNext() {
        return this.index != this.count;
    }

    @Override
    public E next() {
        return (E)this.children[this.index++];
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    public void add(E child) {
        this.children[this.count++] = child;
    }

    public void reset() {
        this.index = 0;
        this.count = 0;
    }
}

