/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.rate;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.uncontended.precipice.BackPressure;
import net.uncontended.precipice.Failable;
import net.uncontended.precipice.GuardRail;

public class RateLimiter<Rejected extends Enum<Rejected>>
implements BackPressure<Rejected> {
    private final Rejected rejectedReason;
    private final long allowedPerPeriod;
    private final AtomicLong count = new AtomicLong(0L);
    private final AtomicLong rolloverTime;
    private final long nanoDuration;

    public RateLimiter(Rejected rejectedReason, long allowedPerPeriod, long duration, TimeUnit timeUnit) {
        this.rejectedReason = rejectedReason;
        this.allowedPerPeriod = allowedPerPeriod;
        this.nanoDuration = timeUnit.toNanos(duration);
        this.rolloverTime = new AtomicLong(System.nanoTime() + this.nanoDuration);
    }

    @Override
    public Rejected acquirePermit(long number, long nanoTime) {
        long proposedCount;
        long currentCount;
        this.adjustTime(nanoTime);
        do {
            if ((proposedCount = (currentCount = this.count.get()) + number) <= this.allowedPerPeriod) continue;
            return this.rejectedReason;
        } while (!this.count.compareAndSet(currentCount, proposedCount));
        return null;
    }

    private void adjustTime(long nanoTime) {
        long localRolloverTime;
        while ((localRolloverTime = this.rolloverTime.get()) <= nanoTime) {
            if (!this.rolloverTime.compareAndSet(localRolloverTime, nanoTime + this.nanoDuration)) continue;
            this.count.set(0L);
        }
        return;
    }

    @Override
    public void releasePermit(long number, long nanoTime) {
    }

    @Override
    public void releasePermit(long number, Failable result, long nanoTime) {
    }

    @Override
    public <Result extends Enum<Result>> void registerGuardRail(GuardRail<Result, Rejected> guardRail) {
    }
}

