/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.semaphore;

import java.util.concurrent.atomic.AtomicLong;
import net.uncontended.precipice.BackPressure;
import net.uncontended.precipice.Failable;
import net.uncontended.precipice.GuardRail;
import net.uncontended.precipice.semaphore.PrecipiceSemaphore;

public class LongSemaphore<Rejected extends Enum<Rejected>>
implements BackPressure<Rejected>,
PrecipiceSemaphore {
    private final AtomicLong permitsRemaining;
    private final long maxConcurrencyLevel;
    private final Rejected reason;

    public LongSemaphore(Rejected reason, long maxConcurrencyLevel) {
        this.maxConcurrencyLevel = maxConcurrencyLevel;
        this.reason = reason;
        this.permitsRemaining = new AtomicLong(maxConcurrencyLevel);
    }

    @Override
    public Rejected acquirePermit(long number, long nanoTime) {
        long permitsRemaining;
        long newRemaining;
        while ((newRemaining = (permitsRemaining = this.permitsRemaining.get()) - number) >= 0L) {
            if (!this.permitsRemaining.compareAndSet(permitsRemaining, newRemaining)) continue;
            return null;
        }
        return this.reason;
    }

    @Override
    public void releasePermit(long number, long nanoTime) {
        this.permitsRemaining.getAndAdd(number);
    }

    @Override
    public void releasePermit(long number, Failable result, long nanoTime) {
        this.permitsRemaining.getAndAdd(number);
    }

    @Override
    public <Result extends Enum<Result>> void registerGuardRail(GuardRail<Result, Rejected> guardRail) {
    }

    @Override
    public long maxConcurrencyLevel() {
        return this.maxConcurrencyLevel;
    }

    @Override
    public long remainingCapacity() {
        return this.permitsRemaining.get();
    }

    @Override
    public long currentConcurrencyLevel() {
        return this.maxConcurrencyLevel - this.permitsRemaining.get();
    }
}

