/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.time;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import net.uncontended.precipice.time.Clock;
import org.HdrHistogram.Histogram;

public class TickingClock
implements Clock {
    public Histogram gram = new Histogram(TimeUnit.MILLISECONDS.toNanos(100L), 3);
    private static final AtomicReference<TickingClock> instance = new AtomicReference();
    private volatile Thread runner;
    private volatile boolean stopped = false;
    private volatile long currentMillis = System.currentTimeMillis();
    private volatile long currentNanos = System.nanoTime();

    @Override
    public long currentTimeMillis() {
        return this.currentMillis;
    }

    @Override
    public long nanoTime() {
        return this.currentNanos;
    }

    private void start() {
        this.runner = new Thread(new TTask());
        this.runner.start();
    }

    public void stop() {
        this.stopped = true;
        this.runner.interrupt();
    }

    public static TickingClock getInstance() {
        TickingClock newClock;
        if (instance.get() == null && instance.compareAndSet(null, newClock = new TickingClock())) {
            newClock.start();
        }
        return instance.get();
    }

    private class TTask
    implements Runnable {
        private TTask() {
        }

        @Override
        public void run() {
            long waitTime = 50000L;
            while (!TickingClock.this.stopped) {
                LockSupport.parkNanos(waitTime);
                TickingClock.this.currentMillis = System.currentTimeMillis();
                long newTime = System.nanoTime();
                TickingClock.this.gram.recordValue(newTime - TickingClock.this.currentNanos);
                TickingClock.this.currentNanos = newTime;
            }
        }
    }
}

