/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.timeout;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.uncontended.precipice.time.Clock;
import net.uncontended.precipice.time.SystemTime;
import net.uncontended.precipice.timeout.Timeout;
import net.uncontended.precipice.timeout.TimeoutService;

public class DelayQueueTimeoutService
implements TimeoutService {
    public static final long MAX_TIMEOUT_MILLIS = 86400000L;
    public static final DelayQueueTimeoutService DEFAULT_TIMEOUT_SERVICE = new DelayQueueTimeoutService("default");
    private final DelayQueue<TimeoutHolder> timeoutQueue = new DelayQueue();
    private final Thread timeoutThread;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final Clock clock;
    private final Thread.UncaughtExceptionHandler exceptionHandler;
    private volatile boolean isRunning = true;

    public DelayQueueTimeoutService(String name) {
        this(name, SystemTime.getInstance(), null);
    }

    public DelayQueueTimeoutService(String name, Clock clock, Thread.UncaughtExceptionHandler exceptionHandler) {
        this.clock = clock;
        this.exceptionHandler = exceptionHandler;
        this.timeoutThread = this.createThread();
        this.timeoutThread.setName(name + "-timeout-thread");
        this.timeoutThread.setDaemon(true);
    }

    @Override
    public void scheduleTimeout(Timeout timeout, long timeoutMillis) {
        this.scheduleTimeout(timeout, timeoutMillis, System.nanoTime());
    }

    @Override
    public void scheduleTimeout(Timeout timeout, long timeoutMillis, long nanoTime) {
        if (!this.isStarted.get()) {
            this.startThread();
        }
        if (!this.isRunning) {
            throw new IllegalArgumentException("Service has been stopped.");
        }
        this.timeoutQueue.offer(new TimeoutHolder(timeout, timeoutMillis, nanoTime));
    }

    public void stop() {
        if (this.isRunning) {
            this.isRunning = false;
            this.timeoutThread.interrupt();
        }
    }

    public static long adjustTimeout(long millisTimeout) {
        return millisTimeout > 86400000L ? 86400000L : millisTimeout;
    }

    private void startThread() {
        if (this.isStarted.compareAndSet(false, true)) {
            this.timeoutThread.start();
        }
    }

    private Thread createThread() {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                while (DelayQueueTimeoutService.this.isRunning) {
                    try {
                        TimeoutHolder task = (TimeoutHolder)DelayQueueTimeoutService.this.timeoutQueue.take();
                        task.setTimedOut();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        break;
                    }
                    catch (Exception e) {
                        if (DelayQueueTimeoutService.this.exceptionHandler != null) {
                            DelayQueueTimeoutService.this.exceptionHandler.uncaughtException(Thread.currentThread(), e);
                            continue;
                        }
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private class TimeoutHolder
    implements Delayed {
        private final Timeout task;
        public final long nanosAbsoluteTimeout;
        public final long millisRelativeTimeout;

        private TimeoutHolder(Timeout task, long millisRelativeTimeout, long nanosAbsoluteStart) {
            this.task = task;
            this.millisRelativeTimeout = millisRelativeTimeout;
            this.nanosAbsoluteTimeout = TimeUnit.NANOSECONDS.convert(millisRelativeTimeout, TimeUnit.MILLISECONDS) + nanosAbsoluteStart;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.nanosAbsoluteTimeout - DelayQueueTimeoutService.this.clock.nanoTime(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            if (o instanceof TimeoutHolder) {
                return Long.compare(this.nanosAbsoluteTimeout, ((TimeoutHolder)o).nanosAbsoluteTimeout);
            }
            return Long.compare(this.getDelay(TimeUnit.NANOSECONDS), o.getDelay(TimeUnit.NANOSECONDS));
        }

        public void setTimedOut() {
            this.task.timeout();
        }
    }
}

