/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import net.uncontended.precipice.BackPressure;
import net.uncontended.precipice.Failable;
import net.uncontended.precipice.GuardRail;
import net.uncontended.precipice.metrics.counts.PartitionedCount;
import net.uncontended.precipice.util.SimulationRejected;

public class Simulation<R extends Enum<R>> {
    private final Gauge gauge = new Gauge();
    private final GuardRail<R, SimulationRejected> guardRail;

    public Simulation(GuardRail<R, SimulationRejected> guardRail) {
        this.wireUpGauge(guardRail);
        this.guardRail = guardRail;
    }

    public void run(Map<R, Callable<Long>> resultToCallable) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int resultTypeCount = resultToCallable.size();
        ArrayList<R> resultTypes = new ArrayList<R>(resultToCallable.keySet());
        long[] resultCounts = new long[resultTypeCount];
        long rejectedCounts = 0L;
        int executions = ((Random)random).nextInt(500) + 500;
        for (int i = 0; i < executions; ++i) {
            long permitNumber;
            boolean shouldReject;
            int j = ((Random)random).nextInt(resultTypeCount);
            boolean bl = shouldReject = ((Random)random).nextInt(4) == 3;
            if (shouldReject) {
                this.gauge.allowNext = false;
            }
            long concurrencyLevel = this.gauge.currentConcurrencyLevel();
            assert (concurrencyLevel == 0L) : String.format("Expected concurrency of 0; Actual: %s", concurrencyLevel);
            try {
                permitNumber = resultToCallable.get(resultTypes.get(j)).call();
                assert (permitNumber == this.gauge.last) : String.format("Expected permit number of %s; Actual: %s", permitNumber, Gauge.access$200(this.gauge));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (shouldReject) {
                rejectedCounts += permitNumber;
            } else {
                resultCounts[j] = resultCounts[j] + permitNumber;
            }
            concurrencyLevel = this.gauge.currentConcurrencyLevel();
            assert (concurrencyLevel == 0L) : String.format("Expected concurrency of 0; Actual: %s", concurrencyLevel);
            this.gauge.allowNext = true;
        }
        Simulation.assertMetrics((PartitionedCount)((Object)this.guardRail.getResultCounts()), resultTypes, resultCounts);
        Simulation.assertRejectedCounts((PartitionedCount)((Object)this.guardRail.getRejectedCounts()), rejectedCounts);
    }

    private void wireUpGauge(GuardRail<R, SimulationRejected> guardRail) {
        try {
            Field f = guardRail.getClass().getDeclaredField("backPressureList");
            f.setAccessible(true);
            List backPressureList = (List)f.get(guardRail);
            backPressureList.add(this.gauge);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static void assertRejectedCounts(PartitionedCount<SimulationRejected> rejectedCounts, long rejectedCount) {
        long actualCount = rejectedCounts.getCount(SimulationRejected.SIMULATION_REJECTION);
        String message = String.format("Expected: %s rejected counts to be returned for %s. Actual: %s.", new Object[]{rejectedCounts, SimulationRejected.SIMULATION_REJECTION, actualCount});
        assert (actualCount == rejectedCount) : message;
    }

    private static <T extends Enum<T>> void assertMetrics(PartitionedCount<T> metrics, List<T> types, long[] counts) {
        for (int i = 0; i < types.size(); ++i) {
            Enum type = (Enum)types.get(i);
            long actualCount = metrics.getCount(type);
            long expectedCount = counts[i];
            String message = String.format("Expected: %s result counts to be returned for %s. Actual: %s.", expectedCount, type, actualCount);
            assert (actualCount == expectedCount) : message;
        }
    }

    private static class Gauge
    implements BackPressure<SimulationRejected> {
        private final AtomicLong concurrencyLevel = new AtomicLong(0L);
        private long last = 0L;
        private boolean allowNext = true;

        private Gauge() {
        }

        @Override
        public SimulationRejected acquirePermit(long number, long nanoTime) {
            this.last = number;
            if (this.allowNext) {
                this.concurrencyLevel.getAndAdd(number);
                return null;
            }
            return SimulationRejected.SIMULATION_REJECTION;
        }

        @Override
        public void releasePermit(long number, long nanoTime) {
            this.concurrencyLevel.getAndAdd(-number);
        }

        @Override
        public void releasePermit(long number, Failable result, long nanoTime) {
            this.concurrencyLevel.getAndAdd(-number);
        }

        @Override
        public <Result extends Enum<Result>> void registerGuardRail(GuardRail<Result, SimulationRejected> guardRail) {
        }

        public long currentConcurrencyLevel() {
            return this.concurrencyLevel.get();
        }
    }
}

