/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.mfa.authentication.handler;

import com.authy.AuthyApiClient;
import com.authy.api.Error;
import com.authy.api.Token;
import com.authy.api.Tokens;
import com.authy.api.User;
import com.authy.api.Users;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.validation.constraints.NotNull;
import net.unicon.cas.mfa.authentication.handler.AuthyAuthenticationHandler;
import net.unicon.cas.mfa.authentication.handler.AuthyUserAccountStore;
import net.unicon.cas.mfa.authentication.handler.InMemoryAuthyUserAccountStore;
import net.unicon.cas.mfa.web.flow.util.MultiFactorRequestContextUtils;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public final class AuthyAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthyAuthenticationHandler.class);
    private static final long serialVersionUID = 4372937413518364597L;
    private final AuthyApiClient authyClient;
    private final Users authyUsers;
    private final Tokens authyTokens;
    private String mailAttribute = "mail";
    private String phoneAttribute = "phone";
    private Boolean forceVerification = Boolean.FALSE;
    private AuthyUserAccountStore authyUserAccountStore = new InMemoryAuthyUserAccountStore();

    public AuthyAuthenticationHandler(@NotNull String apiKey, @NotNull String apiUrl) throws MalformedURLException {
        URL url = new URL(apiUrl);
        boolean testFlag = url.getProtocol().equals("http");
        this.authyClient = new AuthyApiClient(apiKey, apiUrl, testFlag);
        this.authyUsers = this.authyClient.getUsers();
        this.authyTokens = this.authyClient.getTokens();
    }

    protected boolean authenticateUsernamePasswordInternal(UsernamePasswordCredentials usernamePasswordCredentials) throws AuthenticationException {
        RequestContext context = RequestContextHolder.getRequestContext();
        Principal principal = MultiFactorRequestContextUtils.getMultiFactorPrimaryPrincipal((RequestContext)context);
        if (!this.authyUserAccountStore.contains(principal)) {
            String email = (String)principal.getAttributes().get(this.mailAttribute);
            if (StringUtils.isBlank((String)email)) {
                throw new AuthyAuthenticationException(this, "authy.registration.email.error", "No email address found for " + principal.getId(), "emailError");
            }
            String phone = (String)principal.getAttributes().get(this.phoneAttribute);
            if (StringUtils.isBlank((String)phone)) {
                throw new AuthyAuthenticationException(this, "authy.registration.phone.error", "No phone number found for " + principal.getId(), "phoneError");
            }
            User user = this.authyUsers.createUser(email, phone);
            if (!user.isOk()) {
                throw new AuthyAuthenticationException(this, "authy.registration.error", this.getAuthyErrorMessage(user.getError()), "error");
            }
            long authyId = user.getId();
            this.authyUserAccountStore.add(Long.valueOf(authyId), principal);
        }
        Long authyId = this.authyUserAccountStore.get(principal);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("force", this.forceVerification.toString());
        Token verification = this.authyTokens.verify(authyId.intValue(), usernamePasswordCredentials.getUsername(), options);
        if (!verification.isOk()) {
            throw new AuthyAuthenticationException(this, "authy.verification.error", this.getAuthyErrorMessage(verification.getError()), "error");
        }
        return true;
    }

    public void setMailAttribute(String mailAttribute) {
        this.mailAttribute = mailAttribute;
    }

    public void setPhoneAttribute(String phoneAttribute) {
        this.phoneAttribute = phoneAttribute;
    }

    public void setForceVerification(Boolean forceVerification) {
        this.forceVerification = forceVerification;
    }

    public void setAuthyUserAccountStore(AuthyUserAccountStore authyUserAccountStore) {
        this.authyUserAccountStore = authyUserAccountStore;
    }

    private String getAuthyErrorMessage(Error err) {
        StringBuilder builder = new StringBuilder();
        if (err != null) {
            builder.append("Authy Error");
            if (StringUtils.isNotBlank((String)err.getCountryCode())) {
                builder.append(": Country Code: " + err.getCountryCode());
            }
            if (StringUtils.isNotBlank((String)err.getMessage())) {
                builder.append(": Message: " + err.getMessage());
            }
        } else {
            builder.append("An unknown error has occurred. Check your API key and URL settings.");
        }
        return builder.toString();
    }
}

