/*
 * Decompiled with CFR 0.152.
 */
package kotowari.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.collection.Parameters;
import enkan.data.ConversationState;
import enkan.data.Flash;
import enkan.data.HttpRequest;
import enkan.data.PrincipalAvailable;
import enkan.data.Routable;
import enkan.data.Session;
import enkan.exception.MisconfigurationException;
import enkan.security.UserPrincipal;
import enkan.system.inject.ComponentInjector;
import enkan.util.ReflectionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.Conversation;
import kotowari.data.BodyDeserializable;

@Middleware(name="controllerInvoker", dependencies={"params"})
public class ControllerInvokerMiddleware<RES>
implements enkan.Middleware<HttpRequest, RES> {
    Map<Class<?>, Object> controllerCache = new ConcurrentHashMap();
    ComponentInjector injector;

    public ControllerInvokerMiddleware(ComponentInjector injector) {
        this.injector = injector;
    }

    protected Object[] createArguments(HttpRequest request) {
        Method method = ((Routable)request).getControllerMethod();
        Object bodyObj = ((BodyDeserializable)BodyDeserializable.class.cast(request)).getDeserializedBody();
        Object[] arguments = new Object[method.getParameterCount()];
        int parameterIndex = 0;
        for (Parameter parameter : method.getParameters()) {
            Class<?> type = parameter.getType();
            if (HttpRequest.class.isAssignableFrom(type)) {
                arguments[parameterIndex] = request;
            } else if (Session.class.isAssignableFrom(type)) {
                arguments[parameterIndex] = request.getSession();
            } else if (Flash.class.isAssignableFrom(type)) {
                arguments[parameterIndex] = request.getFlash();
            } else if (Parameters.class.isAssignableFrom(type)) {
                arguments[parameterIndex] = request.getParams();
            } else if (UserPrincipal.class.isAssignableFrom(type)) {
                arguments[parameterIndex] = ((PrincipalAvailable)PrincipalAvailable.class.cast(request)).getPrincipal();
            } else if (Conversation.class.isAssignableFrom(type)) {
                arguments[parameterIndex] = request.getConversation();
            } else if (ConversationState.class.isAssignableFrom(type)) {
                ConversationState state = request.getConversationState();
                if (state == null) {
                    state = new ConversationState();
                    request.setConversationState(state);
                }
                arguments[parameterIndex] = state;
            } else if (bodyObj != null && bodyObj.getClass().equals(type)) {
                arguments[parameterIndex] = bodyObj;
            } else {
                throw new MisconfigurationException("PARAMETER_TYPE_MISMATCH", new Object[]{parameterIndex, type});
            }
            ++parameterIndex;
        }
        return arguments;
    }

    private Object inject(Object controller) {
        if (this.injector != null) {
            this.injector.inject(controller);
        }
        return controller;
    }

    public RES handle(HttpRequest request, MiddlewareChain next) {
        if (request instanceof Routable) {
            Method controllerMethod = ((Routable)request).getControllerMethod();
            Class<?> controllerClass = controllerMethod.getDeclaringClass();
            Object controller = this.controllerCache.computeIfAbsent(controllerClass, c -> ReflectionUtils.tryReflection(() -> this.inject(c.newInstance())));
            return (RES)ReflectionUtils.tryReflection(() -> {
                Object[] arguments = this.createArguments(request);
                return controllerMethod.invoke(controller, arguments);
            });
        }
        throw new MisconfigurationException("kotowari.MISSING_IMPLEMENTATION", new Object[]{Routable.class});
    }
}

