/*
 * Decompiled with CFR 0.152.
 */
package kotowari.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.component.builtin.HmacEncoder;
import enkan.data.ConversationState;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.data.PrincipalAvailable;
import enkan.exception.FalteringEnvironmentException;
import enkan.middleware.AbstractWebMiddleware;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.stream.Stream;
import javax.enterprise.context.Conversation;
import javax.inject.Inject;
import kotowari.data.TemplatedHttpResponse;
import kotowari.scope.ExportSetting;
import kotowari.scope.ExportableScope;

@Middleware(name="renderTemplate")
public class RenderTemplateMiddleware
extends AbstractWebMiddleware {
    @Inject
    private HmacEncoder hmacEncoder;
    private ExportSetting exports = ExportSetting.DEFAULT_EXPORTS;

    protected void render(TemplatedHttpResponse response) {
        InputStream is = (InputStream)response.getBody();
        ReadableByteChannel channel = Channels.newChannel(is);
        ByteBuffer buf = ByteBuffer.allocate(4096);
        buf.mark();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int read;
            while ((read = channel.read(buf)) >= 0) {
                baos.write(buf.array(), 0, read);
                buf.reset();
            }
            String body = baos.toString("UTF-8");
            response.setBody(body);
        }
        catch (IOException ex) {
            throw new FalteringEnvironmentException((Throwable)ex);
        }
    }

    public HttpResponse handle(HttpRequest request, MiddlewareChain chain) {
        HttpResponse response = this.castToHttpResponse(chain.next((Object)request));
        if (TemplatedHttpResponse.class.isInstance(response)) {
            TemplatedHttpResponse tres = (TemplatedHttpResponse)((Object)TemplatedHttpResponse.class.cast(response));
            if (this.exports.contains(ExportableScope.REQUEST)) {
                tres.getContext().put(this.exports.getExportName(ExportableScope.REQUEST), request);
            }
            if (this.exports.contains(ExportableScope.PARAMS)) {
                tres.getContext().put(this.exports.getExportName(ExportableScope.PARAMS), request.getParams());
            }
            if (this.exports.contains(ExportableScope.USER_PRINCIPAL)) {
                Stream.of(request).filter(PrincipalAvailable.class::isInstance).map(PrincipalAvailable.class::cast).findFirst().ifPresent(principal -> tres.getContext().put(this.exports.getExportName(ExportableScope.USER_PRINCIPAL), principal.getPrincipal()));
            }
            if (this.exports.contains(ExportableScope.SESSION)) {
                tres.getContext().put(this.exports.getExportName(ExportableScope.SESSION), request.getSession());
            }
            if (this.exports.contains(ExportableScope.CONVERSATION)) {
                Conversation conversation = request.getConversation();
                if (conversation != null && !request.getConversation().isTransient()) {
                    String token = conversation.getId() + "$" + this.hmacEncoder.encodeToHex(conversation.getId() + "$" + conversation.getTimeout()) + "$" + conversation.getTimeout();
                    tres.getContext().put("conversationToken", token);
                }
                tres.getContext().put(this.exports.getExportName(ExportableScope.CONVERSATION), conversation);
            }
            if (this.exports.contains(ExportableScope.CONVERSATION_STATE)) {
                ConversationState conversationState = request.getConversationState();
                tres.getContext().put(this.exports.getExportName(ExportableScope.CONVERSATION_STATE), conversationState);
            }
            this.render(tres);
        }
        return response;
    }
}

