/*
 * Decompiled with CFR 0.152.
 */
package kotowari.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.collection.Headers;
import enkan.collection.OptionMap;
import enkan.collection.Parameters;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.data.Routable;
import enkan.exception.MisconfigurationException;
import enkan.middleware.AbstractWebMiddleware;
import enkan.util.MixinUtils;
import enkan.util.ThreadingUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import kotowari.component.TemplateEngine;
import kotowari.data.TemplatedHttpResponse;
import kotowari.routing.Routes;
import kotowari.routing.RoutingGenerationContext;
import kotowari.routing.UrlRewriter;

@Middleware(name="routing")
public class RoutingMiddleware
extends AbstractWebMiddleware {
    @NotNull
    private Routes routes;
    @Inject
    private TemplateEngine templateEngine;

    public RoutingMiddleware(Routes routes) {
        this.routes = routes;
    }

    protected OptionMap recognizePath(HttpRequest request) {
        return this.routes.recognizePath(request.getUri(), request.getRequestMethod().toUpperCase(Locale.US));
    }

    public HttpResponse handle(HttpRequest request, MiddlewareChain next) {
        Class controllerClass;
        OptionMap routing = this.recognizePath(request = (HttpRequest)MixinUtils.mixin((Object)request, (Class[])new Class[]{Routable.class}));
        if (routing.containsKey((Object)"controller")) {
            controllerClass = (Class)routing.get((Object)"controller");
            String action = routing.getString("action");
            Optional<Method> actionMethod = Arrays.stream(controllerClass.getMethods()).filter(m -> m.getName().equals(action)).findFirst();
            if (!actionMethod.isPresent()) {
                HttpResponse response = HttpResponse.of((String)"NotFound");
                response.setStatus(404);
                return response;
            }
            ((Routable)request).setControllerMethod(actionMethod.get());
        } else {
            HttpResponse response = HttpResponse.of((String)"NotFound");
            response.setStatus(404);
            return response;
        }
        Parameters params = request.getParams();
        routing.keySet().stream().filter(k -> !k.equals("controller") && !k.equals("action")).forEach(k -> params.put(k, (Object)routing.getString(k)));
        HttpResponse response = this.castToHttpResponse(next.next((Object)request));
        Headers headers = response.getHeaders();
        ThreadingUtils.some((Object)headers.getRawType((Object)"Location"), loc -> {
            if (loc instanceof RoutingGenerationContext) {
                headers.replace("Location", (Object)this.routes.generate(((RoutingGenerationContext)loc).getOptions()));
                return headers;
            }
            return null;
        });
        if (response instanceof TemplatedHttpResponse) {
            Function<List, Object> urlForFunction = arguments -> {
                if (arguments.size() < 1) {
                    return "/";
                }
                if (arguments.size() == 1) {
                    return this.routes.generate(UrlRewriter.urlFor(controllerClass, arguments.get(0).toString()).getOptions());
                }
                try {
                    Class<?> ctrlClass = Class.forName(arguments.get(0).toString(), true, Thread.currentThread().getContextClassLoader());
                    return this.routes.generate(UrlRewriter.urlFor(ctrlClass, arguments.get(1).toString()).getOptions());
                }
                catch (ClassNotFoundException e) {
                    throw new MisconfigurationException("core.CLASS_NOT_FOUND", new Object[]{arguments.get(0).toString(), e});
                }
            };
            ((TemplatedHttpResponse)response).getContext().put("urlFor", this.templateEngine.createFunction(urlForFunction));
        }
        return response;
    }

    public Routes getRoutes() {
        return this.routes;
    }

    public void setRoutes(Routes routes) {
        this.routes = routes;
    }
}

