/*
 * Decompiled with CFR 0.152.
 */
package kotowari.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.collection.Headers;
import enkan.data.ContentNegotiable;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.data.Routable;
import enkan.data.Session;
import enkan.security.UserPrincipal;
import enkan.util.BeanBuilder;
import enkan.util.CodecUtils;
import enkan.util.HttpRequestUtils;
import enkan.util.MixinUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import kotowari.data.BodyDeserializable;

@Middleware(name="serDes", dependencies={"contentNegotiation"})
public class SerDesMiddleware
implements enkan.Middleware<HttpRequest, HttpResponse> {
    private final List<MessageBodyReader> bodyReaders = new ArrayList<MessageBodyReader>();
    private final List<MessageBodyWriter> bodyWriters = new ArrayList<MessageBodyWriter>();

    public SerDesMiddleware() {
        this.loadReaderAndWriter();
    }

    private void loadReaderAndWriter() {
        ClassLoader cl = Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElse(this.getClass().getClassLoader());
        for (MessageBodyReader reader : ServiceLoader.load(MessageBodyReader.class, cl)) {
            this.bodyReaders.add(reader);
        }
        for (MessageBodyWriter writer : ServiceLoader.load(MessageBodyWriter.class, cl)) {
            this.bodyWriters.add(writer);
        }
    }

    protected <T> T deserialize(HttpRequest request, Class<T> clazz, Type type, MediaType mediaType) {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        return this.bodyReaders.stream().filter(reader -> reader.isReadable(clazz, type, null, mediaType)).map(arg_0 -> SerDesMiddleware.lambda$deserialize$1(clazz, type, mediaType, (MultivaluedMap)headers, request, arg_0)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    protected InputStream serialize(Object obj, MediaType mediaType) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MultivaluedHashMap headers = new MultivaluedHashMap();
        return this.bodyWriters.stream().filter(writer -> writer.isWriteable(obj.getClass(), obj.getClass(), null, mediaType)).map(arg_0 -> SerDesMiddleware.lambda$serialize$3(obj, mediaType, (MultivaluedMap)headers, baos, arg_0)).filter(Objects::nonNull).map(ByteArrayInputStream::new).findFirst().orElse(null);
    }

    public HttpResponse handle(HttpRequest request, MiddlewareChain chain) {
        Object response;
        Method method = ((Routable)request).getControllerMethod();
        String contentType = HttpRequestUtils.contentType((HttpRequest)(request = (HttpRequest)MixinUtils.mixin((Object)request, (Class[])new Class[]{BodyDeserializable.class})));
        if (contentType != null && !HttpRequestUtils.isUrlEncodedForm((HttpRequest)request)) {
            String[] mediaTypeTokens = contentType.split("/", 2);
            MediaType mediaType = new MediaType(mediaTypeTokens[0], mediaTypeTokens[1]);
            for (Parameter parameter : method.getParameters()) {
                Class<?> type = parameter.getType();
                Type genericType = parameter.getParameterizedType();
                if (HttpRequest.class.isAssignableFrom(type) || Session.class.isAssignableFrom(type) || UserPrincipal.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type)) continue;
                ((BodyDeserializable)request).setDeserializedBody(this.deserialize(request, type, genericType, mediaType));
            }
        }
        if (HttpResponse.class.isInstance(response = chain.next((Object)request))) {
            return (HttpResponse)response;
        }
        MediaType responseType = ((ContentNegotiable)ContentNegotiable.class.cast(request)).getMediaType();
        InputStream in = this.serialize(response, responseType);
        if (in != null) {
            return (HttpResponse)BeanBuilder.builder((Object)HttpResponse.of((InputStream)in)).set(HttpResponse::setHeaders, (Object)Headers.of((String)"Content-Type", (Object)CodecUtils.printMediaType((MediaType)responseType))).build();
        }
        return (HttpResponse)BeanBuilder.builder((Object)HttpResponse.of((String)"Not acceptable")).set(HttpResponse::setStatus, (Object)406).build();
    }

    public void setBodyReaders(MessageBodyReader ... readers) {
        this.bodyReaders.addAll(Arrays.asList(readers));
    }

    public void setBodyWriters(MessageBodyWriter ... writers) {
        this.bodyWriters.addAll(Arrays.asList(writers));
    }

    private static /* synthetic */ byte[] lambda$serialize$3(Object obj, MediaType mediaType, MultivaluedMap headers, ByteArrayOutputStream baos, MessageBodyWriter writer) {
        try {
            writer.writeTo(obj, obj.getClass(), obj.getClass(), null, mediaType, headers, (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static /* synthetic */ Object lambda$deserialize$1(Class clazz, Type type, MediaType mediaType, MultivaluedMap headers, HttpRequest request, MessageBodyReader reader) {
        try {
            return reader.readFrom(clazz, type, null, mediaType, headers, request.getBody());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

