/*
 * Decompiled with CFR 0.152.
 */
package kotowari.middleware;

import enkan.Middleware;
import enkan.MiddlewareChain;
import enkan.component.TransactionComponent;
import enkan.data.Routable;
import enkan.exception.MisconfigurationException;
import enkan.exception.UnreachableException;
import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.Transactional;

public class TransactionMiddleware<REQ, RES>
implements Middleware<REQ, RES> {
    @Inject
    private TransactionComponent transactionComponent;

    private Transactional.TxType getTransactionType(Method m) {
        Transactional transactional = m.getDeclaredAnnotation(Transactional.class);
        return transactional != null ? transactional.value() : null;
    }

    public RES handle(REQ req, MiddlewareChain next) {
        Object res = null;
        if (req instanceof Routable) {
            Routable routable = (Routable)req;
            Method m = routable.getControllerMethod();
            Transactional.TxType type = this.getTransactionType(m);
            if (type != null) {
                TransactionManager tm = this.transactionComponent.getTransactionManager();
                switch (type) {
                    case REQUIRED: {
                        try {
                            tm.begin();
                            res = next.next(req);
                            tm.commit();
                            break;
                        }
                        catch (NotSupportedException e) {
                            throw new UnreachableException((Throwable)e);
                        }
                        catch (SystemException e) {
                            throw new MisconfigurationException("kotowari.TX_UNEXPECTED_CONDITION", new Object[]{e});
                        }
                        catch (HeuristicMixedException e) {
                            throw new MisconfigurationException("kotowari.TX_HEURISTIC_MIXED", new Object[]{e});
                        }
                        catch (HeuristicRollbackException e) {
                            throw new MisconfigurationException("kotowari.TX_HEURISTIC_ROLLBACK", new Object[]{e});
                        }
                        catch (RollbackException e) {
                            throw new MisconfigurationException("kotowari.TX_ROLLBACK", new Object[]{e});
                        }
                    }
                    default: {
                        throw new MisconfigurationException("kotowari.UNSUPPORTED_TX_TYPE", new Object[]{type});
                    }
                }
            } else {
                res = next.next(req);
            }
        } else {
            res = next.next(req);
        }
        return (RES)res;
    }
}

