/*
 * Decompiled with CFR 0.152.
 */
package kotowari.middleware;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.collection.Multimap;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.util.ThreadingUtils;
import java.util.Optional;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import kotowari.data.BodyDeserializable;
import kotowari.data.Validatable;

@Middleware(name="validateForm", dependencies={"form"})
public class ValidateFormMiddleware<RES>
implements enkan.Middleware<HttpRequest, RES> {
    private Validator validator;

    public ValidateFormMiddleware() {
        ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
        this.validator = validatorFactory.getValidator();
    }

    protected Validatable getValidatableForm(HttpRequest request) {
        Object form;
        if (request instanceof BodyDeserializable && (form = ((BodyDeserializable)request).getDeserializedBody()) != null && form instanceof Validatable) {
            return (Validatable)form;
        }
        return null;
    }

    public RES handle(HttpRequest request, MiddlewareChain next) {
        Optional validatableForm = ThreadingUtils.some((Object)this.getValidatableForm(request), form -> {
            Multimap errors = Multimap.empty();
            Set violations = this.validator.validate(form, new Class[0]);
            for (ConstraintViolation violation : violations) {
                errors.add((Object)violation.getPropertyPath().toString(), (Object)violation.getMessage());
            }
            form.setErrors((Multimap<String, String>)errors);
            return form;
        });
        Object response = next.next((Object)request);
        if (HttpResponse.class.isInstance(response) && validatableForm.isPresent() && ((Validatable)validatableForm.get()).hasErrors()) {
            ((HttpResponse)HttpResponse.class.cast(response)).setStatus(400);
        }
        return (RES)response;
    }
}

